/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.Graphics2D;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.Overwrite;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.TopItemState;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public abstract class ElementDrawer
implements ModelElementVisitor {
    protected boolean postfix;
    protected DrawingSpecifications drawingSpecifications;
    private boolean paged = false;
    private boolean shadeAfter = true;
    private TopItemState drawingState;
    protected Graphics2D g;
    protected MDCView currentView;
    protected TextOrientation currentTextOrientation;
    protected TextDirection currentTextDirection;

    public void prepareDrawing(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications;
    }

    public void cleanup() {
        this.drawingSpecifications = null;
    }

    public void drawElement(MDCView e, Graphics2D g, boolean postfix) {
        ModelElement elt = e.getModel();
        this.postfix = postfix;
        if (elt == null) {
            return;
        }
        this.currentView = e;
        this.currentTextDirection = this.drawingSpecifications.getTextDirection();
        this.currentTextOrientation = this.drawingSpecifications.getTextOrientation();
        this.g = g;
        elt.accept(this);
    }

    public abstract void visitAlphabeticText(AlphabeticText var1);

    public void visitBasicItemList(BasicItemList l) {
    }

    public void visitCadrat(Cadrat c) {
    }

    public abstract void visitCartouche(Cartouche var1);

    public void visitHBox(HBox b) {
    }

    public abstract void visitHieroglyph(Hieroglyph var1);

    public abstract void visitHRule(HRule var1);

    public void visitLigature(Ligature l) {
    }

    public void visitLineBreak(LineBreak b) {
    }

    public void visitModifier(Modifier mod) {
    }

    public void visitModifierList(ModifiersList l) {
    }

    public void visitOverwrite(Overwrite o) {
    }

    public void visitPageBreak(PageBreak b) {
    }

    public abstract void visitPhilology(Philology var1);

    public void visitSubCadrat(SubCadrat c) {
    }

    public abstract void visitSuperScript(Superscript var1);

    public void visitTabStop(TabStop t) {
    }

    public void visitTopItemList(TopItemList t) {
    }

    public void visitAbsoluteGroup(AbsoluteGroup g) {
    }

    void setDrawingSpecifications(DrawingSpecifications specifications) {
        this.drawingSpecifications = specifications;
    }

    public TopItemState getDrawingState() {
        return this.drawingState;
    }

    public void setDrawingState(TopItemState state) {
        this.drawingState = state;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public void setPaged(boolean paged) {
        this.paged = paged;
    }

    public boolean isShadeAfter() {
        return this.shadeAfter;
    }

    public void setShadeAfter(boolean shadeAfter) {
        this.shadeAfter = shadeAfter;
    }
}

