/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphsManager;
import jsesh.mdcDisplayer.layout.ExplicitPosition;
import jsesh.resources.ResourcesManager;

public class LigatureManager {
    private static LigatureManager instance = null;
    private Map ligaturesMap = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            String[] t0 = (String[])o1;
            String[] t1 = (String[])o2;
            int result = 0;
            for (int i = 0; result == 0 && i < t0.length && i < t1.length; ++i) {
                result = t0[i].compareTo(t1[i]);
            }
            if (result == 0) {
                result = t0.length - t1.length;
            }
            return result;
        }
    });

    public static LigatureManager getInstance() {
        if (instance == null) {
            instance = new LigatureManager();
            try {
                instance.readTksesh(ResourcesManager.getInstance().getLigatureData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public ExplicitPosition[] getPositions(String[] codes) {
        String[] c = new String[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            c[i] = HieroglyphsManager.getInstance().getCanonicalCode(codes[i]);
        }
        return (ExplicitPosition[])this.ligaturesMap.get(c);
    }

    public void put(String[] codes, ExplicitPosition[] positions) {
        this.ligaturesMap.put(codes, positions);
    }

    public void readTksesh(Reader in) throws IOException {
        String s;
        BufferedReader r = new BufferedReader(in);
        DefaultHieroglyphicFontManager fontmanager = DefaultHieroglyphicFontManager.getInstance();
        while ((s = r.readLine()) != null) {
            int i;
            String[] parts = s.split("\\|");
            String[] codes = parts[0].split("&");
            for (i = 0; i < codes.length; ++i) {
                codes[i] = HieroglyphsManager.getInstance().getCanonicalCode(codes[i]);
            }
            String[] pos = parts[1].split(" ");
            int size = Integer.parseInt(pos[0]);
            ExplicitPosition[] positions = new ExplicitPosition[size];
            int k = 0;
            for (i = 1; i < pos.length; i += 4) {
                float x = Float.parseFloat(pos[i + 1]);
                float y = Float.parseFloat(pos[i + 2]);
                int scale = Integer.parseInt(pos[i + 3]);
                x = x * 1000.0f / 17.0f;
                float h = (float)fontmanager.get(pos[i]).getBbox().getHeight();
                y = (17.0f - y - h) * 1000.0f / 17.0f;
                positions[k] = new ExplicitPosition(x, y, scale);
                ++k;
            }
            this.put(codes, positions);
        }
    }
}

