/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.layout.MDCPagedEditorKit;
import jsesh.mdcDisplayer.layout.PagedLayout;
import jsesh.mdcDisplayer.layout.ViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class PagedViewBuilder
implements ViewBuilder {
    private PagedLayout pagedLayout;
    private MDCView currentView;

    public PagedViewBuilder() {
        this(MDCPagedEditorKit.getDefaultMDCPagedEditorKit().createPagedLayout());
    }

    public PagedViewBuilder(PagedLayout layout) {
        this.pagedLayout = layout;
        this.currentView = null;
    }

    public MDCView buildView(ModelElement elt, DrawingSpecifications drawingSpecifications) {
        return this.buildView(elt, 0, elt.getNumberOfChildren(), drawingSpecifications);
    }

    public MDCView buildView(ModelElement elt, int start, int end, DrawingSpecifications drawingSpecifications) {
        ViewBuilderAux visitor = new ViewBuilderAux(start, end);
        this.getPagedLayout().reset(drawingSpecifications);
        elt.accept(visitor);
        MDCView result = this.currentView;
        this.currentView = null;
        this.getPagedLayout().cleanup();
        return result;
    }

    public void reLayout(MDCView v, DrawingSpecifications drawingSpecifications) {
    }

    public PagedLayout getPagedLayout() {
        return this.pagedLayout;
    }

    public void setPagedLayout(PagedLayout layout) {
        this.pagedLayout = layout;
    }

    private class ViewBuilderAux
    extends ModelElementAdapter {
        int start;
        int end;
        boolean topLevel;

        public ViewBuilderAux(int start, int end) {
            this.start = start;
            this.end = end;
            this.topLevel = true;
        }

        public void visitModifier(Modifier mod) {
            throw new RuntimeException("this method shouldn't be called");
        }

        public void visitModifierList(ModifiersList l) {
            throw new RuntimeException("this method shouldn't be called");
        }

        public void visitDefault(ModelElement t) {
            int b;
            int a;
            MDCView result = new MDCView(t);
            PagedViewBuilder.this.getPagedLayout().preLayoutHook(result, 0);
            if (this.topLevel) {
                a = this.start;
                b = this.end;
            } else {
                a = 0;
                b = t.getNumberOfChildren();
            }
            this.topLevel = false;
            for (int i = a; i < b; ++i) {
                EmbeddedModelElement elt = t.getChildAt(i);
                elt.accept(this);
                result.add(PagedViewBuilder.this.currentView);
            }
            PagedViewBuilder.this.currentView = result;
            PagedViewBuilder.this.getPagedLayout().layout(PagedViewBuilder.this.currentView, 0);
        }

        public void visitHieroglyph(Hieroglyph h) {
            MDCView result = new MDCView(h);
            PagedViewBuilder.this.getPagedLayout().layout(result, 0);
            PagedViewBuilder.this.currentView = result;
        }

        public void visitTopItemList(TopItemList t) {
            MDCView result = new MDCView(t);
            PagedViewBuilder.this.getPagedLayout().preLayoutHook(result, 0);
            this.topLevel = false;
            for (int i = this.start; i < this.end; ++i) {
                TopItem elt = t.getTopItemAt(i);
                elt.accept(this);
                result.add(PagedViewBuilder.this.currentView);
            }
            PagedViewBuilder.this.currentView = result;
            PagedViewBuilder.this.getPagedLayout().layout(PagedViewBuilder.this.currentView, 0);
        }
    }
}

