/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsesh.mdc.constants.LexicalSymbolsUtils;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.OptionsMap;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TopItemState;
import jsesh.mdc.model.ZoneStart;
import jsesh.mdcDisplayer.draw.ElementDrawer;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.utils.TranslitterationUtilities;

public class SimpleElementDrawer
extends ElementDrawer {
    private boolean shading;

    public void prepareDrawing(DrawingSpecifications drawingSpecifications) {
        super.prepareDrawing(drawingSpecifications);
        this.shading = false;
        this.setDrawingState(new TopItemState());
    }

    public void visitAlphabeticText(AlphabeticText t) {
        if (!this.postfix) {
            return;
        }
        if (t.getScriptCode() != '+') {
            String text = t.getText();
            if (t.getScriptCode() == 't') {
                text = TranslitterationUtilities.toLowerCase(text);
            }
            this.g.setFont(this.drawingSpecifications.getFont(t.getScriptCode()));
            this.g.drawString(text, 0, this.g.getFontMetrics().getAscent());
        }
    }

    public void visitCartouche(Cartouche c) {
        if (!this.postfix) {
            return;
        }
        if (this.currentTextOrientation.isHorizontal()) {
            this.visitHorizontalCartouche(c);
        } else {
            this.visitVerticalCartouche(c);
        }
    }

    public void visitHorizontalCartouche(Cartouche c) {
        Point2D.Float pb;
        int rightElement;
        int leftElement;
        Stroke s = this.drawingSpecifications.buildCartoucheStroke(c.getType());
        if (this.currentTextDirection.isLeftToRight()) {
            leftElement = c.getStartPart();
            rightElement = c.getEndPart();
        } else {
            leftElement = c.getEndPart();
            rightElement = c.getStartPart();
        }
        float w1 = this.drawingSpecifications.computeCartouchePartLength(c.getType(), leftElement);
        float w2 = this.drawingSpecifications.computeCartouchePartLength(c.getType(), rightElement);
        float dy = this.drawingSpecifications.getCartoucheLineWidth() / 2.0f;
        float dx = this.drawingSpecifications.getCartoucheLineWidth() / 2.0f;
        if (c.getType() == 102) {
            dy += this.drawingSpecifications.getEnclosureBastionDepth();
        }
        Point2D.Float p1 = new Point2D.Float(w1, dy);
        Point2D.Float p2 = new Point2D.Float(w1, this.currentView.getHeight() - dy);
        Point2D.Float p3 = new Point2D.Float(this.currentView.getWidth() - w2, dy);
        Point2D.Float p4 = new Point2D.Float(this.currentView.getWidth() - w2, this.currentView.getHeight() - dy);
        float loopSkip = this.drawingSpecifications.getCartoucheLoopLength() / 3.0f;
        this.g.setStroke(s);
        if (leftElement != 0) {
            switch (c.getType()) {
                case 99: {
                    float p0x = dx;
                    if (leftElement == 2) {
                        p0x += this.drawingSpecifications.getCartoucheknotLength();
                        this.g.draw(new Line2D.Double((double)dx * 1.5, p1.getY(), (double)dx * 1.5, p2.getY()));
                    }
                    this.g.draw(new CubicCurve2D.Double(p1.getX(), p1.getY(), p0x - loopSkip, p1.getY(), p0x - loopSkip, p2.getY(), p2.getX(), p2.getY()));
                    break;
                }
                case 104: {
                    Point2D.Float pa = new Point2D.Float(dx, dy);
                    pb = new Point2D.Float(dx, this.currentView.getHeight() - dy);
                    this.drawHutEnd(leftElement, pa, pb, p1, p2);
                    break;
                }
                case 115: {
                    Point2D.Float pa = new Point2D.Float(dx, dy);
                    pb = new Point2D.Float(dx, this.currentView.getHeight() - dy);
                    if (leftElement == 1) {
                        this.drawHutEnd(leftElement, pa, pb, p1, p2);
                        break;
                    }
                    this.drawSerekhEnd(p1, p2, pa, pb);
                    break;
                }
            }
        }
        switch (c.getType()) {
            case 99: 
            case 104: 
            case 115: {
                this.g.draw(new Line2D.Float(p1, p3));
                this.g.draw(new Line2D.Float(p2, p4));
                break;
            }
            case 102: {
                float ex = p1.x + this.drawingSpecifications.getEnclosureBastionDepth() + this.drawingSpecifications.getEnclosureBastionSkip();
                this.g.setStroke(s);
                this.g.draw(new Line2D.Float(p1, p3));
                this.g.draw(new Line2D.Float(p2, p4));
                while (ex + this.drawingSpecifications.getEnclosureBastionLength() < p3.x - this.drawingSpecifications.getEnclosureBastionSkip() - this.drawingSpecifications.getEnclosureBastionDepth()) {
                    this.g.fill(new Rectangle2D.Double(ex, p1.getY() - (double)this.drawingSpecifications.getEnclosureBastionDepth(), this.drawingSpecifications.getEnclosureBastionLength(), this.drawingSpecifications.getEnclosureBastionDepth()));
                    this.g.fill(new Rectangle2D.Double(ex, p2.getY(), this.drawingSpecifications.getEnclosureBastionLength(), this.drawingSpecifications.getEnclosureBastionDepth()));
                    ex += this.drawingSpecifications.getEnclosureBastionLength() + this.drawingSpecifications.getEnclosureBastionSkip();
                }
                break;
            }
        }
        if (rightElement != 0) {
            switch (c.getType()) {
                case 99: {
                    float p0x = -dx;
                    if (rightElement == 2) {
                        p0x += -this.drawingSpecifications.getCartoucheknotLength();
                        this.g.draw(new Line2D.Double((double)this.currentView.getWidth() - (double)dx * 1.5, p3.getY(), (double)this.currentView.getWidth() - (double)dx * 1.5, p4.getY()));
                    }
                    this.g.draw(new CubicCurve2D.Double(p3.getX(), p3.getY(), this.currentView.getWidth() + loopSkip + p0x, p3.getY(), this.currentView.getWidth() + loopSkip + p0x, p4.getY(), p4.getX(), p4.getY()));
                    break;
                }
                case 104: {
                    Point2D.Float pa = new Point2D.Float(this.currentView.getWidth() - dx, dy);
                    pb = new Point2D.Float(this.currentView.getWidth() - dx, this.currentView.getHeight() - dy);
                    this.drawHutEnd(rightElement, pa, pb, p3, p4);
                    break;
                }
                case 115: {
                    Point2D.Float pa = new Point2D.Float(this.currentView.getWidth() - dx, dy);
                    pb = new Point2D.Float(this.currentView.getWidth() - dx, this.currentView.getHeight() - dy);
                    if (rightElement == 1) {
                        this.drawHutEnd(rightElement, pa, pb, p3, p4);
                        break;
                    }
                    this.drawSerekhEnd(p3, p4, pa, pb);
                    break;
                }
            }
        }
    }

    public void visitVerticalCartouche(Cartouche c) {
        Point2D.Float pa;
        Stroke s = this.drawingSpecifications.buildCartoucheStroke(c.getType());
        if (this.currentTextDirection.isLeftToRight()) {
            // empty if block
        }
        float w1 = this.drawingSpecifications.computeCartouchePartLength(c.getType(), c.getStartPart());
        float w2 = this.drawingSpecifications.computeCartouchePartLength(c.getType(), c.getEndPart());
        float dy = this.drawingSpecifications.getCartoucheLineWidth() / 2.0f;
        float dx = this.drawingSpecifications.getCartoucheLineWidth() / 2.0f;
        if (c.getType() == 102) {
            dx += this.drawingSpecifications.getEnclosureBastionDepth();
        }
        Point2D.Float p1 = new Point2D.Float(this.currentView.getWidth() - dx, w1);
        Point2D.Float p2 = new Point2D.Float(dx, w1);
        Point2D.Float p3 = new Point2D.Float(this.currentView.getWidth() - dx, this.currentView.getHeight() - dy - w2);
        Point2D.Float p4 = new Point2D.Float(dx, this.currentView.getHeight() - dy - w2);
        float loopSkip = this.drawingSpecifications.getCartoucheLoopLength() / 3.0f;
        this.g.setStroke(s);
        if (c.getStartPart() != 0) {
            switch (c.getType()) {
                case 99: {
                    float p0x = dx;
                    if (c.getStartPart() == 2) {
                        p0x += this.drawingSpecifications.getCartoucheknotLength();
                        this.g.draw(new Line2D.Double(p2.getX(), dy, p1.getX(), dy));
                    }
                    this.g.draw(new CubicCurve2D.Double(p1.getX(), p1.getY(), p1.getX(), p0x - loopSkip, p2.getX(), p0x - loopSkip, p2.getX(), p2.getY()));
                    break;
                }
                case 104: {
                    Point2D.Float pa2 = new Point2D.Float(this.currentView.getWidth() - dx, dy);
                    Point2D.Float pb = new Point2D.Float(dx, dy);
                    this.drawHutEnd(c.getStartPart(), pa2, pb, p1, p2);
                    break;
                }
                case 115: {
                    Point2D.Float pb = new Point2D.Float(dx, dy);
                    pa = new Point2D.Float(this.currentView.getWidth() - dx, dy);
                    if (c.getStartPart() == 1) {
                        this.drawHutEnd(1, pa, pb, p1, p2);
                        break;
                    }
                    this.drawSerekhEnd(p1, p2, pa, pb);
                    break;
                }
            }
        }
        switch (c.getType()) {
            case 99: 
            case 104: 
            case 115: {
                this.g.draw(new Line2D.Float(p1, p3));
                this.g.draw(new Line2D.Float(p2, p4));
                break;
            }
            case 102: {
                float ex = p1.x + this.drawingSpecifications.getEnclosureBastionDepth() + this.drawingSpecifications.getEnclosureBastionSkip();
                this.g.setStroke(s);
                this.g.draw(new Line2D.Float(p1, p3));
                this.g.draw(new Line2D.Float(p2, p4));
                while (ex + this.drawingSpecifications.getEnclosureBastionLength() < p3.x - this.drawingSpecifications.getEnclosureBastionSkip() - this.drawingSpecifications.getEnclosureBastionDepth()) {
                    this.g.fill(new Rectangle2D.Double(ex, p1.getY() - (double)this.drawingSpecifications.getEnclosureBastionDepth(), this.drawingSpecifications.getEnclosureBastionLength(), this.drawingSpecifications.getEnclosureBastionDepth()));
                    this.g.fill(new Rectangle2D.Double(ex, p2.getY(), this.drawingSpecifications.getEnclosureBastionLength(), this.drawingSpecifications.getEnclosureBastionDepth()));
                    ex += this.drawingSpecifications.getEnclosureBastionLength() + this.drawingSpecifications.getEnclosureBastionSkip();
                }
                break;
            }
        }
        if (c.getEndPart() != 0) {
            switch (c.getType()) {
                case 99: {
                    float p0x = -dx;
                    if (c.getEndPart() == 2) {
                        p0x += -this.drawingSpecifications.getCartoucheknotLength();
                        this.g.draw(new Line2D.Double(p4.getX(), (double)this.currentView.getHeight() - (double)dy * 1.5, p3.getX(), (double)this.currentView.getHeight() - (double)dy * 1.5));
                    }
                    this.g.draw(new CubicCurve2D.Double(p3.getX(), p3.getY(), p3.getX(), this.currentView.getHeight() + loopSkip + p0x, p4.getX(), this.currentView.getHeight() + loopSkip + p0x, p4.getX(), p4.getY()));
                    break;
                }
                case 104: {
                    Point2D.Float pb = new Point2D.Float(dx, this.currentView.getHeight() - dy);
                    pa = new Point2D.Float(this.currentView.getWidth() - dx, this.currentView.getHeight() - dy);
                    this.drawHutEnd(c.getEndPart(), pa, pb, p3, p4);
                    break;
                }
                case 115: {
                    Point2D.Float pb = new Point2D.Float(dx, this.currentView.getHeight() - dy);
                    pa = new Point2D.Float(this.currentView.getWidth() - dx, this.currentView.getHeight() - dy);
                    if (c.getEndPart() == 1) {
                        this.drawHutEnd(1, pa, pb, p3, p4);
                        break;
                    }
                    this.drawSerekhEnd(p3, p4, pa, pb);
                    break;
                }
            }
        }
    }

    private void drawSerekhEnd(Point2D p1, Point2D p2, Point2D pa, Point2D pb) {
        if (this.currentTextOrientation.isHorizontal()) {
            double dx = pa.getX() - p1.getX();
            double dy = p2.getY() - p1.getY();
            double line1x = p1.getX() + dx * 0.1;
            double line2x = p1.getX() + dx * 0.3;
            double line3x = p1.getX() + dx * 0.4;
            this.g.draw(new Line2D.Double(p1, pa));
            this.g.draw(new Line2D.Double(p2, pb));
            this.g.draw(new Line2D.Double(line1x, p1.getY(), line1x, p2.getY()));
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
            this.g.draw(new Line2D.Double(line2x, p1.getY(), line2x, p2.getY()));
            this.g.draw(new Line2D.Double(line3x, p1.getY(), line3x, p2.getY()));
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
            double recessX = p1.getX() + dx * 0.5;
            for (int i = 1; i < 10; i += 3) {
                double posy1 = p1.getY() + 0.1 * dy * (double)i;
                double posy2 = p1.getY() + 0.1 * dy * (double)(i + 1);
                double posy3 = p1.getY() + 0.1 * dy * (double)(i + 2);
                double endX = pa.getX();
                this.g.draw(new Line2D.Double(recessX, posy1, endX, posy1));
                this.g.draw(new Line2D.Double(recessX, posy3, endX, posy3));
                this.g.draw(new Line2D.Double(recessX, posy1, recessX, posy3));
                double innerX = recessX + 0.2 * (endX - recessX);
                this.g.draw(new Line2D.Double(innerX, posy2, endX, posy2));
            }
        } else {
            double dx = p2.getX() - p1.getX();
            double dy = pa.getY() - p1.getY();
            double line1y = p1.getY() + dy * 0.1;
            double line2y = p1.getY() + dy * 0.3;
            double line3y = p1.getY() + dy * 0.4;
            this.g.draw(new Line2D.Double(p1, pa));
            this.g.draw(new Line2D.Double(p2, pb));
            this.g.draw(new Line2D.Double(p1.getX(), line1y, p2.getX(), line1y));
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
            this.g.draw(new Line2D.Double(p1.getX(), line2y, p2.getX(), line2y));
            this.g.draw(new Line2D.Double(p1.getX(), line3y, p2.getX(), line3y));
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
            double recessY = p1.getY() + dy * 0.5;
            double endY = pa.getY();
            for (int i = 1; i < 10; i += 3) {
                double posx1 = p1.getX() + 0.1 * dx * (double)i;
                double posx2 = p1.getX() + 0.1 * dx * (double)(i + 1);
                double posx3 = p1.getX() + 0.1 * dx * (double)(i + 2);
                this.g.draw(new Line2D.Double(posx1, recessY, posx1, endY));
                this.g.draw(new Line2D.Double(posx3, recessY, posx3, endY));
                this.g.draw(new Line2D.Double(posx1, recessY, posx3, recessY));
                double innerY = recessY + 0.2 * (endY - recessY);
                this.g.draw(new Line2D.Double(posx2, innerY, posx2, endY));
            }
        }
        this.g.setStroke(this.drawingSpecifications.buildCartoucheStroke(115));
    }

    private void drawHutEnd(int part, Point2D pa, Point2D pb, Point2D p1, Point2D p2) {
        if (part != 0) {
            int xSign = 1;
            int ySign = 1;
            this.g.draw(new Line2D.Float(pa, pb));
            this.g.draw(new Line2D.Float(pa, p1));
            this.g.draw(new Line2D.Float(pb, p2));
            double squareSize = this.drawingSpecifications.getHutSquareSize() - this.drawingSpecifications.getCartoucheLineWidth() / 2.0f;
            if (this.currentTextOrientation.isHorizontal()) {
                if (p1.getX() < pa.getX()) {
                    xSign = -1;
                }
            } else {
                if (pa.getX() < pb.getX()) {
                    xSign = -1;
                }
                if (p1.getY() > pa.getY()) {
                    ySign = -1;
                }
                if (!this.currentTextDirection.isLeftToRight()) {
                    if (part == 2) {
                        part = 3;
                    } else if (part == 3) {
                        part = 2;
                    }
                }
            }
            switch (part) {
                case 2: {
                    Point2D.Double pc;
                    Point2D.Double pcb;
                    Point2D.Double pca;
                    if (this.currentTextOrientation.isHorizontal()) {
                        pca = new Point2D.Double(pb.getX(), pb.getY() - squareSize);
                        pcb = new Point2D.Double(pb.getX() + (double)xSign * squareSize, pb.getY());
                        pc = new Point2D.Double(pb.getX() + (double)xSign * squareSize, pb.getY() - squareSize);
                    } else {
                        pca = new Point2D.Double(pb.getX(), pb.getY() - squareSize * (double)ySign);
                        pcb = new Point2D.Double(pb.getX() + (double)xSign * squareSize, pb.getY());
                        pc = new Point2D.Double(pb.getX() + (double)xSign * squareSize, pb.getY() - squareSize * (double)ySign);
                    }
                    this.g.draw(new Line2D.Float(pca, pc));
                    this.g.draw(new Line2D.Float(pc, pcb));
                    break;
                }
                case 3: {
                    Point2D.Double pc;
                    Point2D.Double pcb;
                    Point2D.Double pca;
                    if (this.currentTextOrientation.isHorizontal()) {
                        pca = new Point2D.Double(pa.getX(), pa.getY() + squareSize);
                        pcb = new Point2D.Double(pa.getX() + (double)xSign * squareSize, pa.getY());
                        pc = new Point2D.Double(pa.getX() + (double)xSign * squareSize, p1.getY() + squareSize);
                    } else {
                        pca = new Point2D.Double(pa.getX(), pa.getY() - squareSize * (double)ySign);
                        pcb = new Point2D.Double(pa.getX() - (double)xSign * squareSize, pa.getY());
                        pc = new Point2D.Double(pa.getX() - (double)xSign * squareSize, pa.getY() - squareSize * (double)ySign);
                    }
                    this.g.draw(new Line2D.Float(pca, pc));
                    this.g.draw(new Line2D.Float(pc, pcb));
                }
            }
        }
    }

    public void visitHieroglyph(Hieroglyph h) {
        if (!this.postfix) {
            return;
        }
        if (h.getModifiers().getBoolean("red")) {
            this.g.setColor(this.drawingSpecifications.getRedColor());
        }
        if (h.getModifiers().getBoolean("i")) {
            this.g.setColor(this.drawingSpecifications.getGrayColor());
        }
        switch (h.getType()) {
            case 3: {
                Color col = this.g.getColor();
                this.g.setColor(this.drawingSpecifications.getRedColor());
                this.drawingSpecifications.getHieroglyphsDrawer().draw(this.g, h.getCode(), 0, this.currentView);
                this.g.setColor(col);
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Color col = this.g.getColor();
                this.g.setColor(this.drawingSpecifications.getGrayColor());
                Rectangle2D.Float r = new Rectangle2D.Float(0.0f, 0.0f, this.currentView.getInternalWidth(), this.currentView.getInternalHeight());
                this.g.fill(r);
                this.g.setColor(col);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                String txt = LexicalSymbolsUtils.getStringForPhilology(h.getType());
                this.g.setFont(this.drawingSpecifications.getFont('l'));
                this.g.drawString(txt, 0, this.g.getFontMetrics().getAscent());
                break;
            }
            default: {
                String c = h.getCode();
                boolean reversed = h.isReversed() ^ this.currentTextDirection.equals(TextDirection.RIGHT_TO_LEFT);
                if (reversed) {
                    this.g.transform(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, this.currentView.getInternalWidth(), 0.0f));
                }
                if (h.getModifiers().isFillX()) {
                    // empty if block
                }
                if (this.drawingSpecifications.getHieroglyphsDrawer().isKnown(c)) {
                    this.drawingSpecifications.getHieroglyphsDrawer().draw(this.g, c, h.getAngle(), this.currentView);
                    break;
                }
                this.g.setFont(this.drawingSpecifications.getSuperScriptFont());
                Dimension2D r = this.drawingSpecifications.getSuperScriptDimensions(c);
                this.g.drawString(c, 0.0f, (float)r.getHeight());
            }
        }
    }

    public void visitHRule(HRule h) {
        if (!this.postfix) {
            return;
        }
        if (h.getType() == 'L') {
            this.g.setStroke(this.drawingSpecifications.getWideStroke());
        } else {
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
        }
        this.g.draw(new Line2D.Float((float)h.getStartPos() / 200.0f * this.drawingSpecifications.getBaseLength(), 0.0f, (float)h.getEndPos() / 200.0f * this.drawingSpecifications.getBaseLength(), 0.0f));
    }

    public void visitPageBreak(PageBreak b) {
        if (!this.postfix) {
            return;
        }
        if (!this.isPaged()) {
            this.g.setStroke(this.drawingSpecifications.getFineStroke());
            this.g.draw(new Line2D.Float(-10000.0f, 0.0f, 10000.0f, 0.0f));
        }
    }

    public void visitPhilology(Philology p) {
        if (!this.postfix) {
            return;
        }
        try {
            this.drawBracket(p.getType() * 2 + 1, this.currentView.getWidth() - this.drawingSpecifications.getPhilologyWidth(p.getType()), 0.0f);
            this.drawBracket(p.getType() * 2, 0.0f, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawBracket(int code, float x, float y) {
        Font f = this.drawingSpecifications.getFont('l');
        Graphics2D tmpG = (Graphics2D)this.g.create();
        tmpG.setFont(f);
        tmpG.translate(x, y);
        String s = LexicalSymbolsUtils.getStringForPhilology(code);
        Rectangle2D d = this.drawingSpecifications.getTextDimensions('l', s);
        double scalex = (double)this.drawingSpecifications.getPhilologyWidth(code) / d.getWidth();
        double scaley = (double)this.currentView.getHeight() / d.getHeight();
        tmpG.scale(scalex, scaley);
        tmpG.drawString(s, (float)(-d.getMinX() * scalex), (float)((d.getHeight() - d.getMaxY()) * scaley));
        tmpG.dispose();
    }

    public void visitSuperScript(Superscript s) {
        if (!this.postfix) {
            return;
        }
        String text = s.getText();
        Dimension2D dims = this.drawingSpecifications.getSuperScriptDimensions(text);
        this.g.setFont(this.drawingSpecifications.getSuperScriptFont());
        this.g.drawString(text.toString(), 0, this.g.getFontMetrics().getAscent());
        this.g.setStroke(this.drawingSpecifications.getFineStroke());
        this.g.draw(new Line2D.Float((float)dims.getWidth() / 2.0f, (float)dims.getHeight() + this.drawingSpecifications.getSmallSkip(), (float)dims.getWidth() / 2.0f, this.currentView.getInternalHeight()));
    }

    public void visitCadrat(Cadrat c) {
        if (this.postfix && this.isShadeAfter()) {
            this.doShade(c);
        }
        if (!this.postfix && !this.isShadeAfter()) {
            this.doShade(c);
        }
    }

    private void doShade(Cadrat c) {
        int localshading = c.getShading();
        if (this.shading) {
            localshading = 15;
        }
        if (localshading != 0) {
            boolean fillTopLeft = false;
            boolean fillTopRight = false;
            boolean fillBottomLeft = false;
            boolean fillBottomRight = false;
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.currentView.getInternalWidth() / 2.0f, this.currentView.getInternalHeight() / 2.0f);
            Color gray = this.drawingSpecifications.getGrayColor();
            Paint currentPaint = this.g.getPaint();
            this.g.setPaint(gray);
            if (this.currentView.getParent() != null && this.currentView.getParent().getDirection().isLeftToRight()) {
                fillTopLeft = (localshading & 1) != 0;
                fillTopRight = (localshading & 2) != 0;
                fillBottomLeft = (localshading & 4) != 0;
                fillBottomRight = (localshading & 8) != 0;
            } else {
                fillTopLeft = (localshading & 2) != 0;
                fillTopRight = (localshading & 1) != 0;
                fillBottomLeft = (localshading & 8) != 0;
                boolean bl = fillBottomRight = (localshading & 4) != 0;
            }
            if (fillTopLeft) {
                this.g.fill(r);
            }
            if (fillTopRight) {
                r.x = this.currentView.getInternalWidth() / 2.0f;
                this.g.fill(r);
            }
            if (fillBottomLeft) {
                r.x = 0.0;
                r.y = this.currentView.getInternalHeight() / 2.0f;
                this.g.fill(r);
            }
            if (fillBottomRight) {
                r.x = this.currentView.getInternalWidth() / 2.0f;
                r.y = this.currentView.getInternalHeight() / 2.0f;
                this.g.fill(r);
            }
            if (this.currentView.getNext() != null) {
                MDCView nextView = this.currentView.getNext();
                if (this.shading && this.currentTextOrientation.isHorizontal() && this.currentView.nextIsHorizontallyAdjacent()) {
                    r.x = this.currentView.getInternalWidth();
                    r.y = 0.0;
                    r.height = this.currentView.getInternalHeight();
                    r.width = nextView.getPosition().x - (double)this.currentView.getInternalWidth();
                    this.g.fill(r);
                }
            }
            this.g.setPaint(currentPaint);
        }
    }

    public void visitComplexLigature(ComplexLigature ligature) {
    }

    public void visitZoneStart(ZoneStart start) {
    }

    public void visitOptionList(OptionsMap list) {
    }
}

