/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TabStop;
import jsesh.mdcDisplayer.layout.TopItemLayout;
import jsesh.mdcDisplayer.layout.Zone;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class ColumnLayout
extends TopItemLayout {
    MDCView documentView;
    Rectangle2D documentArea;
    Point2D insertionPoint;
    Zone zone;
    Point2D.Double zoneStart;
    DrawingSpecifications drawingSpecifications;
    TextDirection currentTextDirection;
    private MDCView subView;
    private LayoutAux aux = new LayoutAux();

    public ColumnLayout(MDCView documentView, DrawingSpecifications drawingSpecifications) {
        this.documentView = documentView;
        this.documentArea = new Rectangle2D.Double();
        this.insertionPoint = new Point2D.Double();
        this.drawingSpecifications = drawingSpecifications;
        this.currentTextDirection = drawingSpecifications.getTextDirection();
    }

    public void layoutElement(MDCView subView) {
        this.subView = subView;
        subView.getModel().accept(this.aux);
        this.subView = null;
    }

    public void endLayout() {
        if (!this.zone.isEmpty()) {
            this.flushZone();
        }
    }

    public Rectangle2D getDocumentArea() {
        return this.documentArea;
    }

    public void startLayout() {
        this.documentView.reset();
        this.drawingSpecifications.setTextOrientation(TextOrientation.VERTICAL);
        this.documentView.setDirection(this.currentTextDirection);
        this.zone = new Zone(0.0, 0.0);
        this.zoneStart = new Point2D.Double();
    }

    private void flushZone() {
        this.zoneStart.y += -this.zone.getMinY();
        this.zoneStart.x += -this.zone.getMinX();
        this.zone.translateBy(this.zoneStart);
        this.documentArea.add(new Rectangle2D.Double(this.zoneStart.x, this.zoneStart.y, this.zone.getWidth(), this.zone.getHeight()));
    }

    private class LayoutAux
    extends ModelElementAdapter {
        private LayoutAux() {
        }

        public void visitLineBreak(LineBreak b) {
            ColumnLayout.this.subView.setHeight(0.1f);
            ColumnLayout.this.subView.setWidth(ColumnLayout.this.drawingSpecifications.getMaxCadratWidth());
            ColumnLayout.this.zone.add(ColumnLayout.this.subView);
            ColumnLayout.this.flushZone();
            ColumnLayout.this.zoneStart.x += ColumnLayout.this.zone.getWidth() + (double)ColumnLayout.this.drawingSpecifications.getColumnSkip();
            ColumnLayout.this.zone = new Zone(0.0, 0.0);
        }

        public void visitPageBreak(PageBreak b) {
            this.visitLineBreak(new LineBreak());
        }

        public void visitTabStop(TabStop t) {
            this.visitDefault(t);
        }

        public void visitAlphabeticText(AlphabeticText t) {
            this.visitDefault(t);
        }

        public void visitDefault(ModelElement t) {
            ColumnLayout.this.zone.add(ColumnLayout.this.subView);
            if (ColumnLayout.this.subView.getHeight() != 0.0f) {
                ColumnLayout.this.zone.moveCurrentPoint(0.0, ColumnLayout.this.subView.getHeight() + ColumnLayout.this.drawingSpecifications.getSmallSkip());
            }
        }
    }
}

