/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdcDisplayer.layout.Layout;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.layout.ViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class SimpleViewBuilder
implements ViewBuilder {
    private MDCView currentView = null;
    private Layout layout;

    public SimpleViewBuilder() {
        this(MDCEditorKit.getBasicMDCEditorKit().createLayout());
    }

    public SimpleViewBuilder(Layout layout) {
        this.layout = layout;
    }

    public MDCView buildView(ModelElement elt, DrawingSpecifications drawingSpecifications) {
        return this.buildView(elt, 0, elt.getNumberOfChildren(), drawingSpecifications);
    }

    public MDCView buildView(ModelElement elt, int start, int end, DrawingSpecifications drawingSpecifications) {
        this.getLayout().reset(drawingSpecifications);
        ViewBuilderAux visitor = new ViewBuilderAux(start, end);
        elt.accept(visitor);
        MDCView result = this.currentView;
        this.currentView = null;
        this.getLayout().cleanup();
        return result;
    }

    public void reLayout(MDCView view, DrawingSpecifications drawingSpecifications) {
        this.getLayout().reset(drawingSpecifications);
        this.getLayout().layout(view, 0);
        this.getLayout().cleanup();
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    private class ViewBuilderAux
    extends ModelElementAdapter {
        int start;
        int end;
        boolean topLevel;
        int depth;

        public ViewBuilderAux(int start, int end) {
            this.start = start;
            this.end = end;
            this.topLevel = true;
            this.depth = 0;
        }

        public void visitModifier(Modifier mod) {
            throw new RuntimeException("this method shouldn't be called");
        }

        public void visitModifierList(ModifiersList l) {
            throw new RuntimeException("this method shouldn't be called");
        }

        public void visitDefault(ModelElement t) {
            int b;
            int a;
            ++this.depth;
            MDCView result = new MDCView(t);
            SimpleViewBuilder.this.getLayout().preLayoutHook(result, this.depth);
            if (this.topLevel) {
                a = this.start;
                b = this.end;
            } else {
                a = 0;
                b = t.getNumberOfChildren();
            }
            this.topLevel = false;
            for (int i = a; i < b; ++i) {
                EmbeddedModelElement elt = t.getChildAt(i);
                elt.accept(this);
                result.add(SimpleViewBuilder.this.currentView);
            }
            SimpleViewBuilder.this.getLayout().layout(result, this.depth);
            SimpleViewBuilder.this.getLayout().postLayoutHook(result, this.depth);
            SimpleViewBuilder.this.currentView = result;
            --this.depth;
        }

        public void visitHieroglyph(Hieroglyph h) {
            MDCView result = new MDCView(h);
            SimpleViewBuilder.this.getLayout().preLayoutHook(result, this.depth + 1);
            SimpleViewBuilder.this.getLayout().layout(result, this.depth + 1);
            SimpleViewBuilder.this.currentView = result;
        }
    }
}

