/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.mdcView;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdcDisplayer.mdcView.ViewIterator;
import jsesh.mdcDisplayer.mdcView.ViewSide;

public class MDCView {
    private static final AffineTransform IDENTITY = new AffineTransform();
    private float angle;
    private double deltaBaseX;
    private double deltaBaseY;
    private boolean xStretchable;
    private boolean yStretchable;
    private TextDirection direction;
    private ModelElement model;
    private MDCView parent;
    private MDCView next;
    private MDCView previous;
    Point2D.Double position;
    private List subViews;
    private float width;
    private float height;
    private float xScale;
    private float yScale;

    public MDCView(ModelElement model) {
        this.setModel(model);
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        this.angle = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.subViews = null;
        this.position = new Point2D.Double();
        this.direction = TextDirection.LEFT_TO_RIGHT;
        this.parent = null;
        this.previous = null;
        this.next = null;
        this.xStretchable = false;
        this.yStretchable = false;
    }

    public void add(MDCView subview) {
        this.addAt(this.getNumberOfSubviews(), subview);
    }

    private void fixSlibingsAt(int index) {
        if (index < 0 || index >= this.getNumberOfSubviews()) {
            return;
        }
        MDCView subv = this.getSubView(index);
        subv.previous = index > 0 ? this.getSubView(index - 1) : null;
        subv.next = index < this.getNumberOfSubviews() - 1 ? this.getSubView(index + 1) : null;
    }

    public void addAt(int i, MDCView subView) {
        this.getSubViews().add(i, subView);
        this.fixSlibingsAt(i - 1);
        this.fixSlibingsAt(i);
        this.fixSlibingsAt(i + 1);
        subView.parent = this;
    }

    public void centerSubViewHorizontally() {
        for (int i = 0; i < this.getNumberOfSubviews(); ++i) {
            MDCView sub = this.getSubView(i);
            float space = (this.getInternalWidth() - sub.getWidth()) / 2.0f;
            sub.getPosition().x = space;
        }
    }

    public void centerSubViewsVertically() {
        for (int i = 0; i < this.getNumberOfSubviews(); ++i) {
            MDCView sub = this.getSubView(i);
            float space = (this.getInternalHeight() - sub.getHeight()) / 2.0f;
            sub.getPosition().y = space;
        }
    }

    public void clear() {
        for (int i = 0; i < this.getSubViews().size(); ++i) {
            this.getSubView((int)i).parent = null;
            this.getSubView((int)i).next = null;
            this.getSubView((int)i).previous = null;
        }
        this.getSubViews().clear();
    }

    private AffineTransform computeAffineTransform() {
        AffineTransform affineTransform;
        if (this.xScale == 0.0f && this.yScale == 0.0f && this.angle == 0.0f) {
            affineTransform = IDENTITY;
        } else {
            affineTransform = new AffineTransform();
            if (this.angle != 0.0f) {
                affineTransform.rotate(this.angle);
            }
            if ((double)this.xScale != 1.0 || (double)this.yScale != 1.0) {
                affineTransform.scale(this.xScale, this.yScale);
            }
        }
        return affineTransform;
    }

    public void distributeFromTopToBottom() {
        if (this.getNumberOfSubviews() > 1) {
            ViewIterator i = this.iterator();
            float minH = this.getSumOfSubViewsHeights();
            float interSpace = (this.getInternalHeight() - minH) / (float)(this.getNumberOfSubviews() - 1);
            double y = 0.0;
            i = this.iterator();
            while (i.hasNext()) {
                MDCView v = i.next();
                v.getPosition().y = y;
                y += (double)(v.getHeight() + interSpace);
            }
        }
    }

    public void distributeHorizontally() {
        int n = this.getNumberOfSubviews();
        if (n > 1) {
            float minW = this.getSumOfSubViewsWidths();
            float interSpace = (this.getInternalWidth() - minW) / (float)(n - 1);
            ViewIterator i = this.iterator();
            double x = 0.0;
            while (i.hasNext()) {
                MDCView v = i.next();
                v.resetPos();
                v.getPosition().x = x;
                x += (double)(v.getWidth() + interSpace);
            }
        }
    }

    public void fitToSubViews(boolean doTranslate) {
        MDCView subView;
        this.width = 0.0f;
        this.height = 0.0f;
        RectangularShape area = null;
        if (this.getNumberOfSubviews() == 0) {
            this.width = 0.0f;
            this.height = 0.0f;
        }
        ViewIterator it = this.iterator();
        while (it.hasNext()) {
            subView = it.next();
            Rectangle2D.Double subViewArea = new Rectangle2D.Double(subView.getPosition().x, subView.getPosition().y, subView.getWidth(), subView.getHeight());
            if (area == null) {
                area = subViewArea;
                continue;
            }
            ((Rectangle2D)area).add(subViewArea);
        }
        if (doTranslate) {
            it = this.iterator();
            while (it.hasNext()) {
                subView = it.next();
                subView.getPosition().x -= area.getMinX();
                subView.getPosition().y -= area.getMinY();
            }
            this.width = (float)area.getWidth() * this.xScale;
            this.height = (float)area.getHeight() * this.yScale;
        } else {
            this.width = (float)area.getMaxX() * this.xScale;
            this.height = (float)area.getMaxY() * this.yScale;
        }
    }

    public AffineTransform getAffineTransform() {
        AffineTransform affineTransform = this.computeAffineTransform();
        return affineTransform;
    }

    public float getAngle() {
        return this.angle;
    }

    public double getDeltaBaseX() {
        return this.deltaBaseX;
    }

    public double getDeltaBaseY() {
        return this.deltaBaseY;
    }

    public TextDirection getDirection() {
        return this.direction;
    }

    public MDCView getFirstSubView() {
        return (MDCView)this.getSubViews().get(0);
    }

    public float getHeight() {
        return this.height;
    }

    public float getInternalHeight() {
        return this.height / this.yScale;
    }

    public float getInternalWidth() {
        return this.width / this.xScale;
    }

    public MDCView getLastSubView() {
        if (this.getNumberOfSubviews() > 0) {
            return this.getSubView(this.getNumberOfSubviews() - 1);
        }
        return null;
    }

    public float getMaximalHeightOfSubView() {
        float result = 0.0f;
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subview = i.next();
            if (!(result < subview.getHeight())) continue;
            result = subview.getHeight();
        }
        return result;
    }

    public float getMaximalWidthOfSubView() {
        float result = 0.0f;
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subview = i.next();
            if (!(result < subview.getWidth())) continue;
            result = subview.getWidth();
        }
        return result;
    }

    public ModelElement getModel() {
        return this.model;
    }

    public int getNumberOfSubviews() {
        if (this.subViews == null) {
            return 0;
        }
        return this.subViews.size();
    }

    public MDCView getParent() {
        return this.parent;
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public MDCView getSubView(int i) {
        return (MDCView)this.subViews.get(i);
    }

    public List getSubViews() {
        if (this.subViews == null) {
            this.subViews = new ArrayList();
        }
        return this.subViews;
    }

    public float getSumOfSubViewsHeights() {
        float result = 0.0f;
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subview = i.next();
            result += subview.getHeight();
        }
        return result;
    }

    public float getSumOfSubViewsWidths() {
        float result = 0.0f;
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subview = i.next();
            result += subview.getWidth();
        }
        return result;
    }

    public float getWidth() {
        return this.width;
    }

    public float getXScale() {
        return this.xScale;
    }

    public float getYScale() {
        return this.yScale;
    }

    public ViewIterator iterator() {
        return new ViewIterator(this, this.getSubViews().listIterator());
    }

    public ViewIterator iterator(int idx) {
        return new ViewIterator(this, this.getSubViews().listIterator(idx));
    }

    public void remove(int idx) {
        MDCView subv = this.getSubView(idx);
        subv.parent = null;
        this.subViews.remove(idx);
        this.fixSlibingsAt(idx - 1);
        this.fixSlibingsAt(idx);
    }

    public void remove(int a, int b) {
        for (int i = b - 1; i >= a; --i) {
            MDCView subv = this.getSubView(i);
            subv.parent = null;
            subv.next = null;
            subv.previous = null;
            this.subViews.remove(i);
        }
        this.fixSlibingsAt(a - 1);
        this.fixSlibingsAt(a);
    }

    public void replaceSubView(int i, MDCView subv) {
        this.subViews.set(i, subv);
        this.fixSlibingsAt(i - 1);
        this.fixSlibingsAt(i);
        this.fixSlibingsAt(i + 1);
        subv.parent = this;
    }

    public void reScale(float scale) {
        float oldXScale = this.xScale;
        float oldYScale = this.yScale;
        this.xScale = scale * oldXScale;
        this.yScale = scale * oldYScale;
        this.width *= scale;
        this.height *= scale;
    }

    public void reset() {
        this.setWidth(0.0f);
        this.setHeight(0.0f);
        this.setModel(this.model);
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        this.angle = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.xStretchable = false;
        this.yStretchable = false;
    }

    public void resetPos() {
        this.position.x = 0.0;
        this.position.y = 0.0;
    }

    public void scaleForMaxHeight(float maxHeight) {
        if (maxHeight == 0.0f) {
            return;
        }
        if (this.getHeight() > maxHeight) {
            float sc = maxHeight / this.getHeight();
            this.reScale(sc);
        }
    }

    public void scaleForMaxWidth(float maxWidth) {
        if (maxWidth == 0.0f) {
            return;
        }
        if (this.getWidth() > maxWidth) {
            float sc = maxWidth / this.getWidth();
            this.reScale(sc);
        }
    }

    public void scaleSubViewsToWidth(float maxWidth) {
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subView = i.next();
            subView.scaleForMaxWidth(maxWidth);
        }
    }

    public void scaleSubViewToHeight(float maxHeight) {
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subView = i.next();
            subView.scaleForMaxHeight(maxHeight);
        }
    }

    public void scaleToFitDimensions(double wantedWidth, double wantedHeight) {
        if ((double)this.getWidth() < wantedWidth && (double)this.getHeight() < wantedHeight) {
            return;
        }
        double zoneScaleW = 1.0;
        double zoneScaleH = 1.0;
        if (this.getWidth() != 0.0f) {
            zoneScaleW = wantedWidth / (double)this.getWidth();
        }
        if (this.getHeight() != 0.0f) {
            zoneScaleH = wantedHeight / (double)this.getHeight();
        }
        this.xScale = this.yScale = (float)Math.min(zoneScaleH, zoneScaleW);
        this.width *= this.xScale;
        this.height *= this.yScale;
    }

    public void scaleToWidth(float w) {
        this.xScale = this.getInternalWidth() != 0.0f ? w / this.getInternalWidth() : 1.0f;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public void setDeltaBaseX(double deltaBaseX) {
        this.deltaBaseX = deltaBaseX;
    }

    public void setDeltaBaseY(double deltaBaseY) {
        this.deltaBaseY = deltaBaseY;
    }

    public void setDirection(TextDirection direction) {
        this.direction = direction;
    }

    public void setHeight(float h) {
        this.height = h;
    }

    public void setModel(ModelElement model) {
        this.model = model;
    }

    public void setPosition(Point2D.Double position) {
        this.position = position;
    }

    public void setSubViewsToHeight() {
        float tmph = this.getInternalHeight();
        ViewIterator it = this.iterator();
        while (it.hasNext()) {
            MDCView subv = it.next();
            if (!(subv.getModel() instanceof SubCadrat)) continue;
            subv.setHeight(tmph);
            subv.distributeFromTopToBottom();
        }
        this.stickSubViewsTo(ViewSide.BOTTOM);
    }

    public void setWidth(float w) {
        this.width = w;
    }

    public void setXScale(float xScale) {
        this.xScale = xScale;
    }

    public void setYScale(float yScale) {
        this.yScale = yScale;
    }

    public void stackTop(float skip) {
        ViewIterator i = this.iterator();
        double y = 0.0;
        while (i.hasNext()) {
            MDCView v = i.next();
            v.resetPos();
            v.getPosition().y = y;
            y += (double)(v.getHeight() + skip);
        }
        this.fitToSubViews(true);
    }

    public void stickSubViewsTo(ViewSide side) {
        ViewIterator i = this.iterator();
        while (i.hasNext()) {
            MDCView subView = i.next();
            if (side.equals(ViewSide.BOTTOM)) {
                subView.getPosition().y = this.getInternalHeight() - subView.getHeight();
                continue;
            }
            if (side.equals(ViewSide.TOP)) {
                subView.getPosition().y = 0.0;
                continue;
            }
            if (side.equals(ViewSide.END)) {
                subView.getPosition().x = this.getWidth() - subView.getWidth();
                continue;
            }
            subView.getPosition().x = 0.0;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[v ");
        b.append(this.model.getClass());
        if (this.model instanceof Hieroglyph) {
            Hieroglyph hie = (Hieroglyph)this.model;
            b.append("(" + hie.getCode() + ")");
        }
        b.append(" w :");
        b.append(this.width);
        b.append(" h :");
        b.append(this.height);
        b.append("position : ");
        b.append(this.getPosition());
        b.append("direction : " + this.direction.toString());
        b.append(" s :");
        b.append(this.xScale);
        b.append(" r :");
        b.append(this.angle);
        if (this.subViews != null) {
            b.append(" ");
            b.append(this.subViews.toString());
        }
        b.append("]");
        return b.toString();
    }

    public MDCView getNext() {
        return this.next;
    }

    public MDCView getPrevious() {
        return this.previous;
    }

    public boolean nextIsHorizontallyAdjacent() {
        return this.next != null && this.next.getPosition().y < this.getPosition().y + (double)this.getHeight();
    }

    public boolean isXStretchable() {
        return this.xStretchable;
    }

    public void setXStretchable(boolean stretchable) {
        this.xStretchable = stretchable;
    }

    public boolean isYStretchable() {
        return this.yStretchable;
    }

    public void setYStretchable(boolean stretchable) {
        this.yStretchable = stretchable;
    }
}

