/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.application;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jsesh.about.AboutDisplayer;
import jsesh.docdisplayer.DocDisplayer;
import jsesh.mdc.utils.MDCSyntaxError;
import jsesh.mdcDisplayer.draw.ViewPrinter;
import jsesh.mdcDisplayer.swing.application.MDCDisplayerAppliFrame;
import jsesh.mdcDisplayer.swing.application.MDCDisplayerAppliWorkflow;
import jsesh.mdcDisplayer.swing.application.actions.SelectCopyPasteConfigurationAction;
import jsesh.mdcDisplayer.swing.application.actions.generic.ForwardedAction;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenu;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenuListener;
import jsesh.mdcDisplayer.swing.splash.SplashScreen;
import jsesh.resources.ResourcesManager;
import jsesh.utils.PlatformDetection;

public class MDCDisplayerAppli {
    private HieroglyphicTextModel data;
    private MDCDisplayerAppliFrame frame;
    private MDCDisplayerAppliWorkflow workflow;
    private JMenuBar menubar;
    SplashScreen splash;
    AbstractAction printAction = new AbstractAction("Print"){

        public void actionPerformed(ActionEvent e) {
            String message = "Please note that the printing facilities still suffer from some bugs.\n";
            message = message + "(page layout problems; shading don't print well)\n";
            message = message + "\nI suggest you use export as pdf instead.\n";
            int ok = JOptionPane.showConfirmDialog(null, message = message + "Do you want to continue printing ?", "warning", 0);
            if (ok == 0) {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                ViewPrinter printer = new ViewPrinter();
                printJob.setPageable(printer);
                printer.setModel(MDCDisplayerAppli.this.data.getModel());
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    };

    public MDCDisplayerAppli() {
        this.data = new HieroglyphicTextModel();
        this.data.setPhilologyIsSign(true);
        this.workflow = new MDCDisplayerAppliWorkflow(this.data);
        String title = "JSesh MDC Editor v. 2.2alpha1";
        this.frame = new MDCDisplayerAppliFrame(title, this.workflow);
        this.workflow.setFrame(this.frame);
        this.menubar = this.buildMenuBar();
        this.frame.setJMenuBar(this.menubar);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MDCDisplayerAppli.this.workflow.exit();
            }
        });
    }

    private void loadDemo() {
        try {
            Reader r = ResourcesManager.getInstance().getDemoData();
            this.data.readModel(r);
            r.close();
        }
        catch (MDCSyntaxError e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JMenuBar buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.add(this.workflow.getNewAction());
        menu.add(this.workflow.getLoadTextAction());
        menu.add(this.workflow.getSaveTextAction());
        JMenu exportMenu = new JMenu("Export as");
        menu.add(exportMenu);
        menu.addSeparator();
        menu.add(this.workflow.getExitAction());
        menubar.add(menu);
        exportMenu.add(this.workflow.getBitmapExportAction());
        exportMenu.add(this.workflow.getWmfExportAction());
        exportMenu.add(this.workflow.getHtmlExportAction());
        exportMenu.add(this.workflow.getIPDFExportAction());
        exportMenu.add(this.workflow.getRtfExportAction());
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic(69);
        this.addWithShortCut(edit, this.workflow.getCutAction(), 88);
        this.addWithShortCut(edit, this.workflow.getCopyAction(), 67);
        this.addWithShortCut(edit, this.workflow.getPasteAction(), 86);
        edit.addSeparator();
        this.addWithShortCut(edit, this.workflow.getSelectAllAction(), 65);
        edit.addSeparator();
        this.addWithShortCut(edit, this.workflow.getSetHieroglyphicModeAction(), 78);
        this.addWithShortCut(edit, this.workflow.getSetLatinModeAction(), 68);
        this.addWithShortCut(edit, this.workflow.getSetBoldModeAction(), 66);
        this.addWithShortCut(edit, this.workflow.getSetItalicModeAction(), 73);
        this.addWithShortCut(edit, this.workflow.getSetTransliterationModeAction(), 84);
        edit.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem copyAndPaste1 = new JRadioButtonMenuItem(new SelectCopyPasteConfigurationAction("copy : large size", this.workflow, 0));
        JRadioButtonMenuItem copyAndPaste2 = new JRadioButtonMenuItem(new SelectCopyPasteConfigurationAction("copy : small size", this.workflow, 1));
        group.add(copyAndPaste1);
        group.add(copyAndPaste2);
        edit.add(copyAndPaste1);
        edit.add(copyAndPaste2);
        copyAndPaste1.setSelected(true);
        menubar.add(edit);
        JMenu manipulate = new JMenu("Text Manipulation");
        manipulate.setMnemonic(84);
        this.addWithShortCut(manipulate, this.workflow.getGroupHorizontallyAction(), 72);
        this.addWithShortCut(manipulate, this.workflow.getGroupVerticallyAction(), 71);
        this.addWithShortCut(manipulate, this.workflow.getLigatureAction(), 76);
        this.addWithShortCut(manipulate, this.workflow.getLigatureBeforeAction(), 75);
        this.addWithShortCut(manipulate, this.workflow.getLigatureAfterAction(), 77);
        this.addWithShortCut(manipulate, this.workflow.getExplodeGroupAction(), 69);
        manipulate.addSeparator();
        this.addWithShortCut(manipulate, this.workflow.getInsertSpaceAction(), 80);
        this.addWithShortCut(manipulate, this.workflow.getInsertHalfSpaceAction(), 80, 64);
        this.addWithShortCut(manipulate, this.workflow.getInsertPageBreakAction(), 10, 64);
        this.addWithShortCut(manipulate, this.workflow.getInsertRedPointAction(), 79);
        this.addWithShortCut(manipulate, this.workflow.getInsertBlackPointAction(), 79, 64);
        manipulate.addSeparator();
        this.addWithShortCut(manipulate, this.workflow.getShadeZoneAction(), 90);
        this.addWithShortCut(manipulate, this.workflow.getUnShadeZoneAction(), 90, 64);
        this.addWithShortCut(manipulate, this.workflow.getPaintRedAction(), 82);
        this.addWithShortCut(manipulate, this.workflow.getPaintBlackAction(), 82, 64);
        this.addWithShortCut(manipulate, this.workflow.getEditGroupAction(), 71, 64);
        manipulate.addSeparator();
        JMenu sign = new JMenu("Sign");
        sign.setMnemonic(83);
        sign.add(this.workflow.getReverseSignAction());
        JMenu size = new JMenu("Size");
        size.setMnemonic(83);
        int[] sizes = new int[]{240, 200, 144, 120, 100, 70, 50, 35, 25, 1};
        for (int i = 0; i < sizes.length; ++i) {
            size.add(this.workflow.buildSizeAction(sizes[i]));
        }
        sign.add(size);
        JMenu rotation = new JMenu("Rotation");
        rotation.setMnemonic(82);
        for (int i = 0; i < this.workflow.getRotations().length; ++i) {
            rotation.add(this.workflow.getRotations()[i]);
        }
        sign.add(rotation);
        sign.add(this.workflow.getToggleRedSignAction());
        sign.add(this.workflow.getToggleWideSignAction());
        sign.addSeparator();
        sign.add(this.workflow.getToggleGrammarAction());
        sign.add(this.workflow.getSignIsInWordAction());
        sign.add(this.workflow.getSignIsWordEndAction());
        sign.add(this.workflow.getSignIsSentenceEndAction());
        sign.add(this.workflow.getSignIsInWordAction());
        sign.add(this.workflow.getToggleIgnoredSignAction());
        this.buildShadingMenu(manipulate);
        this.buildCartoucheMenu(manipulate);
        this.buildPhilologicalMenu(manipulate);
        menubar.add(manipulate);
        menubar.add(sign);
        JMenu view = new JMenu("View");
        view.setMnemonic(86);
        view.add(this.workflow.getHalfZoomAction());
        view.add(this.workflow.getDoubleZoomAction());
        view.add(this.workflow.getResetZoomAction());
        view.addSeparator();
        JMenu orientationMenu = new JMenu("Orientation");
        JMenu directionMenu = new JMenu("Direction");
        view.add(orientationMenu);
        view.add(directionMenu);
        view.addSeparator();
        view.add(new JCheckBoxMenuItem(this.workflow.getSelectCenteredSignsAction()));
        menubar.add(view);
        ButtonGroup orientationGroup = new ButtonGroup();
        JRadioButtonMenuItem horizontalButton = new JRadioButtonMenuItem(new ForwardedAction(this.workflow, "Horizontal", "SELECT_HORIZONTAL_ORIENTATION"));
        JRadioButtonMenuItem verticalButton = new JRadioButtonMenuItem(new ForwardedAction(this.workflow, "Vertical", "SELECT_VERTICAL_ORIENTATION"));
        orientationGroup.add(horizontalButton);
        orientationGroup.add(verticalButton);
        orientationMenu.add(horizontalButton);
        orientationMenu.add(verticalButton);
        ButtonGroup directionGroup = new ButtonGroup();
        JRadioButtonMenuItem leftToRightButton = new JRadioButtonMenuItem(new ForwardedAction(this.workflow, "Left to Right", "SELECT_L2R_DIRECTION"));
        JRadioButtonMenuItem rightToLeftButton = new JRadioButtonMenuItem(new ForwardedAction(this.workflow, "Right to Left", "SELECT_R2L_DIRECTION"));
        directionGroup.add(rightToLeftButton);
        directionGroup.add(leftToRightButton);
        directionMenu.add(leftToRightButton);
        directionMenu.add(rightToLeftButton);
        this.buildHieroglyphicMenus(menubar);
        this.buildToolsMenus(menubar);
        menubar.add(Box.createHorizontalGlue());
        JMenu help = new JMenu("Help");
        help.setMnemonic(76);
        help.add(new AbstractAction("About JSesh"){

            public void actionPerformed(ActionEvent e) {
                AboutDisplayer about = new AboutDisplayer(MDCDisplayerAppli.this.frame);
                about.show();
            }
        });
        help.add(new AbstractAction("JSesh user documentation"){

            public void actionPerformed(ActionEvent e) {
                DocDisplayer.getInstance().setVisible(true);
            }
        });
        help.add(new AbstractAction("Display java properties"){

            public void actionPerformed(ActionEvent e) {
                Properties props = System.getProperties();
                StringWriter string = new StringWriter();
                PrintWriter out = new PrintWriter(string);
                props.list(out);
                JTextArea textArea = new JTextArea(string.toString());
                JScrollPane pane = new JScrollPane(textArea);
                pane.setPreferredSize(new Dimension(320, 200));
                JOptionPane.showMessageDialog(MDCDisplayerAppli.this.frame, pane);
            }
        });
        menubar.add(help);
        return menubar;
    }

    private void buildToolsMenus(JMenuBar menubar2) {
        JMenu tools = new JMenu("Tools");
        tools.add(this.workflow.getAddNewSignsAction());
        tools.addSeparator();
        tools.add(new AbstractAction("Edit preferences"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppli.this.workflow.editPreferences();
            }
        });
        menubar2.add(tools);
    }

    private void buildPhilologicalMenu(JMenu menubar) {
        JMenu philology = new JMenu("Philological Markup");
        philology.setMnemonic(80);
        JPopupMenu pm = philology.getPopupMenu();
        pm.setLayout(new GridLayout(0, 4));
        String[] tips = new String[]{"Erased text", "Editor addition", "Superfluous signs", "Previously readable signs", "Scribe addition"};
        for (int i = 0; i < this.workflow.getPhilologyActions().length; ++i) {
            JMenuItem sub = new JMenuItem(this.workflow.getPhilologyActions()[i]);
            if (i < tips.length) {
                sub.setToolTipText(tips[i]);
            }
            philology.add(sub);
        }
        menubar.add(philology);
    }

    private void buildCartoucheMenu(JMenu menubar) {
        JMenu cartouche = new JMenu("Cartouche");
        cartouche.setMnemonic(67);
        JPopupMenu pm = cartouche.getPopupMenu();
        pm.setLayout(new GridLayout(0, 4));
        for (int i = 0; i < this.workflow.getCartoucheActions().length; ++i) {
            cartouche.add(this.workflow.getCartoucheActions()[i]);
        }
        menubar.add(cartouche);
    }

    private void buildShadingMenu(JMenu menubar) {
        JMenu shading = new JMenu("Shading");
        shading.setMnemonic(72);
        JPopupMenu pm = shading.getPopupMenu();
        pm.setLayout(new GridLayout(0, 4));
        for (int i = 0; i < this.workflow.getShadeActions().length; ++i) {
            shading.add(this.workflow.getShadeActions()[i]);
        }
        menubar.add(shading);
    }

    private void addWithShortCut(JMenu menu, AbstractAction action, int vk, int mask) {
        JMenuItem item = new JMenuItem(action);
        item.setAccelerator(KeyStroke.getKeyStroke(vk, mask | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
    }

    private void addWithShortCut(JMenu menu, AbstractAction action, int vk) {
        JMenuItem item = new JMenuItem(action);
        item.setAccelerator(KeyStroke.getKeyStroke(vk, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
    }

    private void buildHieroglyphicMenus(JMenuBar menubar) {
        String[] families = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "Aa", "Ff"};
        String[] titles = new String[]{"A. Man and his occupations", "B. Woman and her occupations", "C. Anthropomorphic Deities", "D. Parts of the human body", "E. Mammals", "F. Parts of Mammals", "G. Birds", "H. Parts of Birds", "I. Amphibious animals, reptiles, etc.", "K. Fishes and parts of fishes", "L. Invertebrata and lesser animals", "M. Trees and plants", "N. Sky, earth, water", "O. Buildings, parts of buildings, etc.", "P. Ships and parts of ships", "Q. Domestic and funerary furniture", "R. Temple furniture and sacred emblems", "S. Crowns, Dress, Staves, etc.", "T. Warfare, hunting, butchery", "U. Agriculture, crafts, and professions", "V. Rope, Fibre, baskets, bags, etc.", "W. Vessels of stone and earthenware", "X. Loaves and cakes", "Y. Writings, games, music", "Z. Strokes", "Aa. Unclassified (J)", "Ff. Hieratic signs, Gardiner, JEA 15 (&)"};
        JMenu hieroglyphs = new JMenu("Hieroglyphs");
        hieroglyphs.getPopupMenu().setLayout(new GridLayout(14, 2));
        for (int i = 0; i < families.length; ++i) {
            HieroglyphicMenu fmenu = new HieroglyphicMenu(titles[i], families[i], 6);
            fmenu.setHieroglyphicMenuListener(new HieroglyphicMenuMediator());
            if (i < 25) {
                fmenu.setMnemonic(families[i].toUpperCase().charAt(0));
            } else if (i == 25) {
                fmenu.setMnemonic(74);
            } else if (i == 26) {
                fmenu.setMnemonic(150);
            }
            hieroglyphs.add(fmenu);
        }
        hieroglyphs.setMnemonic(72);
        menubar.add(hieroglyphs);
    }

    public void setInitialFile(File f) {
        try {
            FileReader r = new FileReader(f);
            this.workflow.loadFile(f);
            ((Reader)r).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (PlatformDetection.getPlatform() != 0 && PlatformDetection.getPlatform() == 2) {
                UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticLookAndFeel");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File f;
            SplashScreen splash = new SplashScreen();
            splash.display();
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
            MDCDisplayerAppli a = new MDCDisplayerAppli();
            boolean noTextWasLoaded = true;
            if (args.length > 0 && (f = new File(args[0])).exists()) {
                a.setInitialFile(f);
                noTextWasLoaded = false;
            }
            if (noTextWasLoaded) {
                a.loadDemo();
            }
            a.frame.addWindowListener(new SplashCloser(splash));
            StartMe run = new StartMe(a.frame);
            SwingUtilities.invokeLater(run);
        }
        catch (Exception e) {
            String message = "An unexpected error occurred when starting jsesh.\ncan you please note the message and send a mail to rosmord@iut.univ-paris8.fr about it?\n" + e.getMessage();
            StringWriter string = new StringWriter();
            PrintWriter out = new PrintWriter(string);
            e.printStackTrace(out);
            JTextArea textArea = new JTextArea(e.getMessage() + "\n" + string.toString());
            JScrollPane pane = new JScrollPane(textArea);
            pane.setPreferredSize(new Dimension(640, 400));
            JOptionPane.showMessageDialog(null, pane, "Problem", 0);
        }
    }

    private static class SplashCloser
    extends WindowAdapter {
        private SplashScreen splash;

        public SplashCloser(SplashScreen splash) {
            this.splash = splash;
        }

        public void windowOpened(WindowEvent e) {
            this.splash.setVisible(false);
            this.splash.dispose();
        }
    }

    private static class StartMe
    implements Runnable {
        MDCDisplayerAppliFrame startme;

        public StartMe(MDCDisplayerAppliFrame startme) {
            this.startme = startme;
        }

        public void run() {
            this.startme.setVisible(true);
        }
    }

    private class HieroglyphicMenuMediator
    implements HieroglyphicMenuListener {
        private HieroglyphicMenuMediator() {
        }

        public void codeSelected(String code) {
            MDCDisplayerAppli.this.workflow.insert(code);
        }

        public void enter(String code) {
            MDCDisplayerAppli.this.workflow.displaySignInfo(code);
        }

        public void exit(String code) {
            MDCDisplayerAppli.this.workflow.setMessage("");
        }
    }
}

