/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdcDisplayer.draw.MDCCaret;
import jsesh.mdcDisplayer.swing.application.MDCDisplayerAppliWorkflow;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import jsesh.mdcDisplayer.swing.editor.MDCModelEditionAdapter;
import jsesh.mdcDisplayer.swing.editor.MDCModelEditionListener;
import jsesh.swingUtils.StringDisplayer;

public class MDCDisplayerAppliFrame
extends JFrame {
    JMDCEditor editor;
    JTextField codeField;
    JTextField separatorField;
    StringDisplayer messageField;
    JProgressBar progressBar;
    JTextField mdcField;

    public JMDCEditor getEditor() {
        return this.editor;
    }

    public MDCDisplayerAppliFrame(String title, MDCDisplayerAppliWorkflow workflow) throws HeadlessException {
        super(title);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/jseshResources/images/hiboux.png"));
        this.setIconImage(icon.getImage());
        this.editor = new JMDCEditor(workflow.getData());
        this.editor.setDrawingSpecifications(workflow.getDrawingSpecifications());
        this.editor.setMdcModelTransferableBroker(workflow);
        CodeModel codeModel = new CodeModel();
        this.editor.addCodeChangeListener(codeModel);
        this.codeField = new JTextField(5);
        this.codeField.setEnabled(false);
        this.codeField.setFocusable(false);
        this.codeField.setDisabledTextColor(this.codeField.getForeground());
        this.codeField.setToolTipText("current Manuel de codage code being typed");
        this.separatorField = new JTextField(1);
        this.separatorField.setEnabled(false);
        this.separatorField.setFocusable(false);
        this.separatorField.setDisabledTextColor(this.separatorField.getForeground());
        this.separatorField.setToolTipText("Manuel de codage separator to use");
        JScrollPane scroll = new JScrollPane(this.editor);
        this.messageField = new StringDisplayer(workflow.getMessage(), 30);
        this.messageField.setToolTipText("Various messages");
        this.progressBar = new JProgressBar();
        this.progressBar.setToolTipText("Progress bar for future uses.");
        JSplitPane bottom2 = new JSplitPane();
        JSplitPane bottom1 = new JSplitPane();
        JSplitPane bottom3 = new JSplitPane();
        bottom2.setLeftComponent(this.messageField);
        bottom2.setRightComponent(this.progressBar);
        bottom3.setRightComponent(bottom2);
        bottom3.setLeftComponent(this.separatorField);
        bottom1.setLeftComponent(this.codeField);
        bottom1.setRightComponent(bottom3);
        this.mdcField = new JTextField();
        this.mdcField.setToolTipText("Here you can edit the manuel de codage code for the current line.");
        JPanel bottomPanel = new JPanel();
        this.editor.getWorkflow().addMDCModelListener(new MDCModelEditionAdapter(){

            public void caretChanged(MDCCaret caret) {
                MDCDisplayerAppliFrame.this.getCurrentMDCLine();
            }

            public void textChanged() {
                MDCDisplayerAppliFrame.this.getCurrentMDCLine();
            }

            public void textEdited(ModelOperation op) {
                MDCDisplayerAppliFrame.this.getCurrentMDCLine();
            }
        });
        this.mdcField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliFrame.this.setCurrentMDCLine();
            }
        });
        bottomPanel.add(this.mdcField);
        bottomPanel.add(bottom1);
        bottomPanel.setLayout(new GridLayout(2, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(800, 600);
    }

    private void getCurrentMDCLine() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String s = MDCDisplayerAppliFrame.this.editor.getWorkflow().getCurrentLineAsString();
                MDCDisplayerAppliFrame.this.mdcField.setText(s);
            }
        });
    }

    private void setCurrentMDCLine() {
        this.editor.getWorkflow().setCurrentLineTo(this.mdcField.getText());
    }

    private class CodeModel
    implements MDCModelEditionListener {
        private CodeModel() {
        }

        public void focusGained(StringBuffer code) {
        }

        public void focusLost() {
        }

        public String getText() {
            if (MDCDisplayerAppliFrame.this.editor.getCodeBuffer() != null) {
                return MDCDisplayerAppliFrame.this.editor.getCodeBuffer();
            }
            return "";
        }

        public void textEdited(ModelOperation op) {
        }

        public void textChanged() {
        }

        public void caretChanged(MDCCaret caret) {
        }

        public void separatorChanged() {
            MDCDisplayerAppliFrame.this.separatorField.setText("" + MDCDisplayerAppliFrame.this.getEditor().getCurrentSeparator());
        }

        public void codeChanged(StringBuffer code) {
            MDCDisplayerAppliFrame.this.codeField.setText(MDCDisplayerAppliFrame.this.getEditor().getCodeBuffer());
        }
    }
}

