/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.application;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jsesh.externalFonts.ExternalSignImporter;
import jsesh.graphicExport.BitmapExporter;
import jsesh.graphicExport.CaretBroker;
import jsesh.graphicExport.ExportData;
import jsesh.graphicExport.HTMLExporter;
import jsesh.graphicExport.IPDFExporter;
import jsesh.graphicExport.RTFExportPreferences;
import jsesh.graphicExport.RTFExporterUI;
import jsesh.graphicExport.WMFExporter;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphsManager;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.output.ModelWriter;
import jsesh.mdc.utils.MDCSyntaxError;
import jsesh.mdcDisplayer.clipboard.MDCModelTransferable;
import jsesh.mdcDisplayer.draw.MDCCaret;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.mdcDisplayer.swing.actionsUtils.PreferenceBoundAction;
import jsesh.mdcDisplayer.swing.actionsUtils.PreferencesChangeListener;
import jsesh.mdcDisplayer.swing.application.CaretActionManager;
import jsesh.mdcDisplayer.swing.application.MDCDisplayerAppliFrame;
import jsesh.mdcDisplayer.swing.application.MDCIconAction;
import jsesh.mdcDisplayer.swing.application.actions.generic.ForwardedAction;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import jsesh.mdcDisplayer.swing.editor.MDCModelTransferableBroker;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorDialog;
import jsesh.mdcDisplayer.swing.preferencesEditor.PreferencesEditor;
import jsesh.mdcDisplayer.swing.preferencesEditor.PreferencesFacade;
import jsesh.mdcDisplayer.swing.units.LengthUnit;
import jsesh.utils.FileUtils;
import jsesh.utils.SimpleStringModel;

public class MDCDisplayerAppliWorkflow
implements CaretBroker,
MDCModelTransferableBroker {
    private PreferenceBoundAction addNewSignsAction = new PreferenceBoundAction("Add new signs"){

        public void actionPerformed(ActionEvent e) {
            ExternalSignImporter importer = new ExternalSignImporter();
            importer.setSourceDirectory(MDCDisplayerAppliWorkflow.this.currentHieroglyphsSource);
            JOptionPane.showMessageDialog(MDCDisplayerAppliWorkflow.this.frame, importer.getPanel(), "Import new signs", -1);
            MDCDisplayerAppliWorkflow.this.currentHieroglyphsSource = importer.getSourceDirectory();
        }

        public void preferencesChanged() {
            File directory = DefaultHieroglyphicFontManager.getInstance().getDirectory();
            this.setEnabled(directory.isDirectory());
        }
    };
    private AbstractAction bitmapExportAction;
    private BitmapExporter bitmapExporter = null;
    private AbstractAction buildAddedSignsBlock = new MDCIconAction("[&-gm-D3-&]"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addPhilologicalMarkup(51);
        }
    };
    private AbstractAction buildErasedSignBlock = new MDCIconAction("[[-gm-D3-]]"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addPhilologicalMarkup(50);
        }
    };
    private AbstractAction buildPreviouslyReadableBlock = new MDCIconAction("[\"-gm-D3-\"]"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addPhilologicalMarkup(53);
        }
    };
    private AbstractAction buildScribeAdditionBlock = new MDCIconAction("['-gm-D3-']"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addPhilologicalMarkup(54);
        }
    };
    private AbstractAction buildSuperfluousSignsBlock = new MDCIconAction("[{-gm-D3-}]"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addPhilologicalMarkup(52);
        }
    };
    private CaretActionManager caretActionManager;
    private CartoucheAction[] cartoucheActions;
    private AbstractAction copyAction;
    private File currentFile;
    private File currentMDCDirectory;
    private File currentRTFExportFile = null;
    private File currentOutputDirectory;
    private File currentHieroglyphsSource;
    private AbstractAction cutAction;
    private HieroglyphicTextModel data;
    private DrawingSpecifications drawingSpecifications;
    private AbstractAction doubleZoomAction;
    private AbstractAction editGroupAction = new AbstractAction("Edit group"){

        public void actionPerformed(ActionEvent e) {
            AbsoluteGroup g = MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().buildAbsoluteGroup();
            if (g != null) {
                GroupEditorDialog d = new GroupEditorDialog();
                d.setGroup(g);
                JOptionPane.showConfirmDialog(MDCDisplayerAppliWorkflow.this.frame, d, "Group editor", 2, -1);
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().fixAbsoluteGroup(g);
            }
        }
    };
    private AbstractAction exitAction;
    private AbstractAction explodeGroupAction;
    private MDCDisplayerAppliFrame frame;
    private AbstractAction groupHorizontallyAction;
    private AbstractAction groupVerticallyAction;
    private AbstractAction halfZoomAction;
    private AbstractAction htmlExportAction;
    private HTMLExporter htmlExporter = null;
    private AbstractAction insertBlackPointAction = new InsertElementAction(new Hieroglyph(4), "O");
    private AbstractAction insertHalfSpaceAction = new AbstractAction("Insert Half Space"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().insertHalfSpace();
        }
    };
    private AbstractAction insertPageBreakAction;
    private AbstractAction insertRedPointAction = new InsertElementAction(new Hieroglyph(3), "o");
    private AbstractAction insertSpaceAction = new AbstractAction("Insert Space"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().insertSpace();
        }
    };
    private AbstractAction ipdfExportAction;
    private AbstractAction rtfExportAction;
    private IPDFExporter iPDFExporter = null;
    private AbstractAction ligatureAction = new AbstractAction("Ligature elements"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().ligatureElements();
        }
    };
    private AbstractAction ligatureBeforeAction = new AbstractAction("ligature group with hieroglyph"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().ligatureBefore();
        }
    };
    private AbstractAction ligatureAfterAction = new AbstractAction("ligature hieroglyph with group"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().ligatureAfter();
        }
    };
    private AbstractAction loadTextAction;
    private SimpleStringModel message;
    private AbstractAction newAction;
    private AbstractAction paintBlackAction = new AbstractAction("Paint zone in black"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().redZone(false);
        }
    };
    private AbstractAction paintRedAction = new AbstractAction("Paint zone in Red"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().redZone(true);
        }
    };
    private AbstractAction pasteAction;
    private AbstractAction[] philologicalActions = null;
    private Preferences preferences;
    private AbstractAction resetZoomAction;
    private AbstractAction reverseSignAction = new AbstractAction("Reverse sign"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().reverseSign();
        }
    };
    private AbstractAction[] rotationActions = null;
    private AbstractAction saveTextAction;
    private AbstractAction selectAllAction;
    private AbstractAction setBoldModeAction = new AbstractAction("Edit bold text"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setMode('b');
        }
    };
    private AbstractAction setHieroglyphicModeAction = new AbstractAction("Edit Hieroglyphs"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setMode('s');
        }
    };
    private AbstractAction setItalicModeAction = new AbstractAction("Edit italic text"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setMode('i');
        }
    };
    private AbstractAction setLatinModeAction = new AbstractAction("Edit latin text"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setMode('l');
        }
    };
    private AbstractAction setTransliterationModeAction = new AbstractAction("Edit translitteration"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setMode('t');
        }
    };
    private AbstractAction[] shadeActions;
    private AbstractAction shadeZoneAction = new AbstractAction("Shade zone"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().shadeZone(true);
        }
    };
    private AbstractAction signIsInWordAction = new AbstractAction("Sign inside a word"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setSignIsInsideWord();
        }
    };
    private AbstractAction signIsSentenceEndAction = new AbstractAction("Sign is at sentence end"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setSignIsAtSentenceEnd();
        }
    };
    private AbstractAction signIsWordEndAction = new AbstractAction("Sign is at word end"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().setSignIsAtWordEnd();
        }
    };
    private AbstractAction toggleGrammarAction = new AbstractAction("Toggle Grammar"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().toggleGrammar();
        }
    };
    private AbstractAction toggleIgnoredSignAction = new AbstractAction("Toggle Ignored Sign"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().toggleIgnoredSign();
        }
    };
    private AbstractAction toggleRedSignAction = new AbstractAction("Toggle sign is red"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().toggleRedSign();
        }
    };
    private AbstractAction toggleWideSignAction = new AbstractAction("Toggle wide sign"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().toggleWideSign();
        }
    };
    private AbstractAction unShadeZoneAction = new AbstractAction("Unshade zone"){

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().shadeZone(false);
        }
    };
    private AbstractAction wmfExportAction;
    private WMFExporter wmfExporter;
    private List preferencesListeners;
    private RTFExportPreferences[] rtfExportPreferences;
    private LengthUnit preferedUnit;
    private int rtfExportPreferencesIndex;

    public MDCDisplayerAppliWorkflow(HieroglyphicTextModel data) {
        this.data = data;
        this.preferencesListeners = new ArrayList();
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.rtfExportPreferences = new RTFExportPreferences[]{new RTFExportPreferences(20, RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT), new RTFExportPreferences(14, RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT), new RTFExportPreferences(20, RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT)};
        this.rtfExportPreferencesIndex = 0;
        this.preferedUnit = LengthUnit.POINT;
        this.wmfExporter = new WMFExporter();
        this.setPhilologySign(true);
        this.frame = null;
        String dir = System.getProperty("user.dir");
        this.currentMDCDirectory = new File(dir);
        this.currentOutputDirectory = new File(dir);
        this.currentHieroglyphsSource = new File(dir);
        this.message = new SimpleStringModel("");
        this.buildActions();
        this.drawingSpecifications = new DrawingSpecifications();
        this.refreshFromPreferences();
        this.currentFile = this.getDefaultFile();
        this.addPreferencesChangeListener(this.addNewSignsAction);
        this.firePreferencesChange();
    }

    private File getDefaultFile() {
        return new File(this.currentMDCDirectory, "default.gly");
    }

    public void addPreferencesChangeListener(PreferencesChangeListener l) {
        this.preferencesListeners.add(l);
    }

    public void firePreferencesChange() {
        for (int i = 0; i < this.preferencesListeners.size(); ++i) {
            ((PreferencesChangeListener)this.preferencesListeners.get(i)).preferencesChanged();
        }
    }

    private void buildActions() {
        this.loadTextAction = new AbstractAction("Open"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.loadText();
            }
        };
        this.loadTextAction.putValue("MnemonicKey", new Integer(79));
        this.saveTextAction = new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.saveText();
            }
        };
        this.saveTextAction.putValue("MnemonicKey", new Integer(83));
        this.exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.exit();
            }
        };
        this.exitAction.putValue("MnemonicKey", new Integer(120));
        this.halfZoomAction = new AbstractAction("unzoom"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().setScale(MDCDisplayerAppliWorkflow.this.getEditor().getScale() / Math.sqrt(2.0));
            }
        };
        this.doubleZoomAction = new AbstractAction("zoom"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().setScale(MDCDisplayerAppliWorkflow.this.getEditor().getScale() * Math.sqrt(2.0));
            }
        };
        this.resetZoomAction = new AbstractAction("Reset zoom"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().setScale(2.0);
            }
        };
        this.htmlExportAction = new AbstractAction("export as HTML"){

            public void actionPerformed(ActionEvent e) {
                if (MDCDisplayerAppliWorkflow.this.htmlExporter == null) {
                    MDCDisplayerAppliWorkflow.this.htmlExporter = new HTMLExporter();
                    MDCDisplayerAppliWorkflow.this.htmlExporter.setDirectory(new File(MDCDisplayerAppliWorkflow.this.currentOutputDirectory, "testhtml"));
                    MDCDisplayerAppliWorkflow.this.htmlExporter.setBaseName("test");
                }
                if (MDCDisplayerAppliWorkflow.this.htmlExporter.getOptionPanel(MDCDisplayerAppliWorkflow.this.frame, "Export as HTML").askAndSet() == 0) {
                    MDCDisplayerAppliWorkflow.this.htmlExporter.setDrawingSpecifications(MDCDisplayerAppliWorkflow.this.getDrawingSpecifications());
                    MDCDisplayerAppliWorkflow.this.htmlExporter.exportModel(MDCDisplayerAppliWorkflow.this.data.getModel());
                }
            }
        };
        this.bitmapExportAction = new AbstractAction("Export as Bitmap picture"){

            public void actionPerformed(ActionEvent e) {
                if (MDCDisplayerAppliWorkflow.this.bitmapExporter == null) {
                    MDCDisplayerAppliWorkflow.this.bitmapExporter = new BitmapExporter();
                }
                boolean selectionOnly = MDCDisplayerAppliWorkflow.this.getCaret().hasSelection();
                if (MDCDisplayerAppliWorkflow.this.bitmapExporter.askUser(selectionOnly) == 0) {
                    ExportData exportData = new ExportData(MDCDisplayerAppliWorkflow.this.getDrawingSpecifications(), MDCDisplayerAppliWorkflow.this.getCaret(), MDCDisplayerAppliWorkflow.this.getData().getModel(), 2.0);
                    MDCDisplayerAppliWorkflow.this.bitmapExporter.export(exportData);
                }
            }
        };
        this.wmfExportAction = new AbstractAction("Export as WMF"){

            public void actionPerformed(ActionEvent e) {
                if (MDCDisplayerAppliWorkflow.this.getCaret().hasSelection() && MDCDisplayerAppliWorkflow.this.wmfExporter.askUser() == 0) {
                    ExportData exportData = new ExportData(MDCDisplayerAppliWorkflow.this.getDrawingSpecifications(), MDCDisplayerAppliWorkflow.this.getCaret(), MDCDisplayerAppliWorkflow.this.getData().getModel(), 1.0);
                    MDCDisplayerAppliWorkflow.this.wmfExporter.export(exportData);
                }
            }
        };
        this.wmfExportAction.putValue("MnemonicKey", new Integer(119));
        this.ipdfExportAction = new AbstractAction("Export as PDF"){

            public void actionPerformed(ActionEvent e) {
                if (MDCDisplayerAppliWorkflow.this.iPDFExporter == null) {
                    MDCDisplayerAppliWorkflow.this.iPDFExporter = new IPDFExporter();
                    MDCDisplayerAppliWorkflow.this.iPDFExporter.setFile(new File(MDCDisplayerAppliWorkflow.this.currentOutputDirectory, "default.pdf"));
                }
                if (MDCDisplayerAppliWorkflow.this.iPDFExporter.getOptionPanel(MDCDisplayerAppliWorkflow.this.frame, "Export as PDF").askAndSet() == 0) {
                    try {
                        MDCDisplayerAppliWorkflow.this.iPDFExporter.exportModel(MDCDisplayerAppliWorkflow.this.data.getModel());
                        MDCDisplayerAppliWorkflow.this.currentOutputDirectory = MDCDisplayerAppliWorkflow.this.iPDFExporter.getFile().getParentFile();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Error while exporting to pdf " + e1.getMessage(), "Problem when exporting", 0);
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.rtfExportAction = new AbstractAction("Export as RTF"){

            public void actionPerformed(ActionEvent e) {
                RTFExporterUI rtfExporterUI = new RTFExporterUI(MDCDisplayerAppliWorkflow.this.currentRTFExportFile, MDCDisplayerAppliWorkflow.this.rtfExportPreferences[2]);
                if (rtfExporterUI.getOptionPanel(MDCDisplayerAppliWorkflow.this.frame, "Export as RTF").askAndSet() == 0) {
                    rtfExporterUI.exportModel(MDCDisplayerAppliWorkflow.this.drawingSpecifications, MDCDisplayerAppliWorkflow.this.data.getModel());
                    MDCDisplayerAppliWorkflow.this.currentOutputDirectory = rtfExporterUI.getFile().getParentFile();
                }
            }
        };
        this.newAction = new AbstractAction("New"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().clear();
                MDCDisplayerAppliWorkflow.this.currentFile = MDCDisplayerAppliWorkflow.this.getDefaultFile();
            }
        };
        this.newAction.putValue("MnemonicKey", new Integer(78));
        this.selectAllAction = new AbstractAction("Select All"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().selectAll();
            }
        };
        this.insertPageBreakAction = new AbstractAction("Insert Page Break"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().insertPageBreak();
            }
        };
        this.explodeGroupAction = new AbstractAction("Explode group"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().explodeGroup();
            }
        };
        this.groupVerticallyAction = new AbstractAction("Group Vertically"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().groupVertical();
            }
        };
        this.groupHorizontallyAction = new AbstractAction("Group Horizontally"){

            public void actionPerformed(ActionEvent e) {
                MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().groupHorizontal();
            }
        };
        this.pasteAction = new ForwardedAction(this, "Paste", "PASTE");
        this.copyAction = new ForwardedAction(this, "Copy", "COPY");
        this.cutAction = new ForwardedAction(this, "Cut", "CUT");
        this.buildShadeActions();
        this.buildCartoucheActions();
        int[] angles = new int[]{0, 30, 45, 60, 90, 120, 135, 150, 180, 210, 225, 240, 270, 300, 315, 330};
        this.rotationActions = new AbstractAction[angles.length];
        for (int i = 0; i < this.rotationActions.length; ++i) {
            this.rotationActions[i] = new RotationAction(angles[i]);
        }
    }

    private void buildCartoucheActions() {
        this.cartoucheActions = new CartoucheAction[23];
        int i = 0;
        this.cartoucheActions[i++] = new CartoucheAction(99, 1, 2, "<-ra-mn:n-xpr\\R270->");
        this.cartoucheActions[i++] = new CartoucheAction(99, 1, 1, "<1-ra-mn:n-xpr\\R270-1>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 2, 1, "<2-ra-mn:n-xpr\\R270-1>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 2, 1, "<2-ra-mn:n-xpr\\R270-2>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 0, 1, "<0-ra-mn:n-xpr\\R270-1>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 1, 0, "<1-ra-mn:n-xpr\\R270-0>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 2, 0, "<2-ra-mn:n-xpr\\R270-0>");
        this.cartoucheActions[i++] = new CartoucheAction(99, 0, 2, "<0-ra-mn:n-xpr\\R270-2>");
        this.cartoucheActions[i++] = new CartoucheAction(115, 1, 2, "<s-E1:D40-xa:M-R19->");
        this.cartoucheActions[i++] = new CartoucheAction(115, 2, 1, "<s2-E1:D40-xa:M-R19-s1>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 1, 2, "<h1-ra-xa-f-h2>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 1, 3, "<h1-ra-xa-f-h3>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 1, 1, "<h1-ra-xa-f-h1>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 1, 0, "<h1-ra-xa-f-h0>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 2, 1, "<h2-ra-xa-f-h1>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 2, 0, "<h2-ra-xa-f-h0>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 3, 1, "<h3-ra-xa-f-h1>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 3, 0, "<h3-ra-xa-f-h0>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 0, 2, "<h0-ra-xa-f-h2>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 0, 3, "<h0-ra-xa-f-h3>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 0, 1, "<h0-ra-xa-f-h1>");
        this.cartoucheActions[i++] = new CartoucheAction(104, 0, 0, "<h0-ra-xa-f-h0>");
        this.cartoucheActions[i++] = new CartoucheAction(70, 1, 2, "<F-ra-xa-f->");
    }

    private void buildShadeActions() {
        this.shadeActions = new ShadeAction[16];
        this.shadeActions[0] = new ShadeAction(0, "..");
        this.shadeActions[1] = new ShadeAction(1, "..#1");
        this.shadeActions[2] = new ShadeAction(2, "..#2");
        this.shadeActions[3] = new ShadeAction(3, "..#12");
        this.shadeActions[4] = new ShadeAction(4, "..#3");
        this.shadeActions[5] = new ShadeAction(5, "..#13");
        this.shadeActions[6] = new ShadeAction(6, "..#23");
        this.shadeActions[7] = new ShadeAction(7, "..#123");
        this.shadeActions[8] = new ShadeAction(8, "..#4");
        this.shadeActions[9] = new ShadeAction(9, "..#14");
        this.shadeActions[10] = new ShadeAction(10, "..#24");
        this.shadeActions[11] = new ShadeAction(11, "..#124");
        this.shadeActions[12] = new ShadeAction(12, "..#34");
        this.shadeActions[13] = new ShadeAction(13, "..#134");
        this.shadeActions[14] = new ShadeAction(14, "..#234");
        this.shadeActions[15] = new ShadeAction(15, "..#1234");
    }

    public AbstractAction buildSizeAction(int size) {
        return new SizeAction(size);
    }

    public void displaySignInfo(String code) {
        String info = code + " : ";
        List l = HieroglyphsManager.getInstance().getValuesFor(code);
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                info = info + i.next().toString() + " ";
            }
        }
        this.setMessage(info);
    }

    public void exit() {
        this.savePreferences();
        System.exit(0);
    }

    public AbstractAction getAddNewSignsAction() {
        return this.addNewSignsAction;
    }

    public AbstractAction getBitmapExportAction() {
        return this.bitmapExportAction;
    }

    public MDCCaret getCaret() {
        return this.frame.editor.getWorkflow().getCaret();
    }

    public CartoucheAction[] getCartoucheActions() {
        return this.cartoucheActions;
    }

    public AbstractAction getCopyAction() {
        return this.copyAction;
    }

    public File getCurrentMDCDirectory() {
        return this.currentMDCDirectory;
    }

    public File getCurrentOutputDirectory() {
        return this.currentOutputDirectory;
    }

    public AbstractAction getCutAction() {
        return this.cutAction;
    }

    public HieroglyphicTextModel getData() {
        return this.data;
    }

    public AbstractAction getDoubleZoomAction() {
        return this.doubleZoomAction;
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public AbstractAction getEditGroupAction() {
        return this.editGroupAction;
    }

    public JMDCEditor getEditor() {
        return this.frame.editor;
    }

    public AbstractAction getExitAction() {
        return this.exitAction;
    }

    public AbstractAction getExplodeGroupAction() {
        return this.explodeGroupAction;
    }

    public AbstractAction getGroupHorizontallyAction() {
        return this.groupHorizontallyAction;
    }

    public AbstractAction getGroupVerticallyAction() {
        return this.groupVerticallyAction;
    }

    public AbstractAction getHalfZoomAction() {
        return this.halfZoomAction;
    }

    public AbstractAction getHtmlExportAction() {
        return this.htmlExportAction;
    }

    public AbstractAction getInsertBlackPointAction() {
        return this.insertBlackPointAction;
    }

    public AbstractAction getInsertHalfSpaceAction() {
        return this.insertHalfSpaceAction;
    }

    public AbstractAction getInsertPageBreakAction() {
        return this.insertPageBreakAction;
    }

    public AbstractAction getInsertRedPointAction() {
        return this.insertRedPointAction;
    }

    public AbstractAction getInsertSpaceAction() {
        return this.insertSpaceAction;
    }

    public AbstractAction getIPDFExportAction() {
        return this.ipdfExportAction;
    }

    public AbstractAction getRtfExportAction() {
        return this.rtfExportAction;
    }

    public AbstractAction getLigatureAction() {
        return this.ligatureAction;
    }

    public AbstractAction getLoadTextAction() {
        return this.loadTextAction;
    }

    public SimpleStringModel getMessage() {
        return this.message;
    }

    public AbstractAction getNewAction() {
        return this.newAction;
    }

    public AbstractAction getPaintBlackAction() {
        return this.paintBlackAction;
    }

    public AbstractAction getPaintRedAction() {
        return this.paintRedAction;
    }

    public AbstractAction getPasteAction() {
        return this.pasteAction;
    }

    public AbstractAction[] getPhilologicalActions() {
        return this.philologicalActions;
    }

    public AbstractAction[] getPhilologyActions() {
        if (this.philologicalActions == null) {
            ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
            AbstractAction[] block = new AbstractAction[]{this.buildErasedSignBlock, this.buildAddedSignsBlock, this.buildSuperfluousSignsBlock, this.buildPreviouslyReadableBlock, this.buildScribeAdditionBlock};
            l.addAll(Arrays.asList(block));
            l.add(new InsertElementAction(new Hieroglyph(100), "[["));
            l.add(new InsertElementAction(new Hieroglyph(101), "]]"));
            l.add(new InsertElementAction(new Hieroglyph(102), "[&"));
            l.add(new InsertElementAction(new Hieroglyph(103), "&]"));
            l.add(new InsertElementAction(new Hieroglyph(104), "[{"));
            l.add(new InsertElementAction(new Hieroglyph(105), "}]"));
            l.add(new InsertElementAction(new Hieroglyph(106), "[\""));
            l.add(new InsertElementAction(new Hieroglyph(107), "\"]"));
            l.add(new InsertElementAction(new Hieroglyph(108), "['"));
            l.add(new InsertElementAction(new Hieroglyph(109), "']"));
            this.philologicalActions = l.toArray(new AbstractAction[l.size()]);
        }
        return this.philologicalActions;
    }

    public AbstractAction getResetZoomAction() {
        return this.resetZoomAction;
    }

    public AbstractAction getReverseSignAction() {
        return this.reverseSignAction;
    }

    public AbstractAction[] getRotations() {
        return this.rotationActions;
    }

    public AbstractAction getSaveTextAction() {
        return this.saveTextAction;
    }

    public AbstractAction getSelectAllAction() {
        return this.selectAllAction;
    }

    public AbstractAction getSetBoldModeAction() {
        return this.setBoldModeAction;
    }

    public AbstractAction getSetHieroglyphicModeAction() {
        return this.setHieroglyphicModeAction;
    }

    public AbstractAction getSetItalicModeAction() {
        return this.setItalicModeAction;
    }

    public AbstractAction getSetLatinModeAction() {
        return this.setLatinModeAction;
    }

    public AbstractAction getSetTransliterationModeAction() {
        return this.setTransliterationModeAction;
    }

    public AbstractAction[] getShadeActions() {
        return this.shadeActions;
    }

    public AbstractAction getShadeZoneAction() {
        return this.shadeZoneAction;
    }

    public AbstractAction getSignIsInWordAction() {
        return this.signIsInWordAction;
    }

    public AbstractAction getSignIsSentenceEndAction() {
        return this.signIsSentenceEndAction;
    }

    public AbstractAction getSignIsWordEndAction() {
        return this.signIsWordEndAction;
    }

    public AbstractAction getToggleGrammarAction() {
        return this.toggleGrammarAction;
    }

    public AbstractAction getToggleIgnoredSignAction() {
        return this.toggleIgnoredSignAction;
    }

    public AbstractAction getToggleRedSignAction() {
        return this.toggleRedSignAction;
    }

    public AbstractAction getToggleWideSignAction() {
        return this.toggleWideSignAction;
    }

    public AbstractAction getUnShadeZoneAction() {
        return this.unShadeZoneAction;
    }

    public AbstractAction getWmfExportAction() {
        return this.wmfExportAction;
    }

    public void insert(String code) {
        this.getEditor().getWorkflow().addSign(code);
    }

    public boolean isPhilologySign() {
        return this.data.isPhilologyIsSign();
    }

    public void loadText() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("choose a manuel de codage text");
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".hie") || pathname.getName().endsWith(".HIE") || pathname.getName().endsWith(".gly") || pathname.getName().endsWith(".GLY") || pathname.isDirectory();
            }

            public String getDescription() {
                return "Manuel de codage files";
            }
        };
        fc.addChoosableFileFilter(filter);
        fc.setCurrentDirectory(this.currentMDCDirectory);
        int result = fc.showOpenDialog(this.frame);
        if (result == 0) {
            try {
                this.getEditor().getWorkflow().setMDCCode("");
            }
            catch (MDCSyntaxError e1) {
                e1.printStackTrace();
            }
            this.currentMDCDirectory = fc.getCurrentDirectory();
            File file = fc.getSelectedFile();
            this.loadFile(file);
        }
    }

    public void loadFile(File file) {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            FileReader r = new FileReader(file);
            while ((c = ((Reader)r).read()) != -1) {
                buffer.append((char)c);
            }
            ((Reader)r).close();
            if (buffer.length() != 0 && buffer.charAt(0) == '@') {
                int first = buffer.indexOf("\n");
                if (first == -1) {
                    first = buffer.length();
                }
                buffer.replace(0, first, "");
            }
            this.setPhilologySign(!file.getName().endsWith(".hie"));
            this.data.readModel(new StringReader(buffer.toString()));
            this.currentFile = file;
        }
        catch (MDCSyntaxError e) {
            String msg = "error at line " + e.getLine();
            int infPos = e.getCharPos() - 10 > 0 ? e.getCharPos() - 10 : 0;
            int supPos = e.getCharPos() + 10 > buffer.length() ? buffer.length() : e.getCharPos() + 10;
            msg = msg + ". Wrong text : " + buffer.substring(infPos, supPos);
            JOptionPane.showMessageDialog(this.frame, msg, "Syntax Error", 0);
            e.getCharPos();
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void philologyToggle() {
    }

    public void refreshFromPreferences() {
        String path = this.preferences.get("currentMDCDirectory", this.currentMDCDirectory.getAbsolutePath());
        this.currentMDCDirectory = new File(path);
        String outputPath = this.preferences.get("currentOutputDirectory", this.currentOutputDirectory.getAbsolutePath());
        this.currentOutputDirectory = new File(outputPath);
        this.currentRTFExportFile = new File(this.preferences.get("RTFExportFile", new File(this.currentOutputDirectory, "unnamed.rtf").getAbsolutePath()));
        this.wmfExporter.setExportFile(new File(this.preferences.get("wmfExportFile", new File(this.currentOutputDirectory, "unnamed.wmf").getPath())));
        path = this.preferences.get("currentHieroglyphsSource", this.currentHieroglyphsSource.getAbsolutePath());
        this.currentHieroglyphsSource = new File(path);
        this.rtfExportPreferences[0].setCadratHeight(this.preferences.getInt("rtf_large_size", 20));
        this.rtfExportPreferences[0].setExportGranularity(RTFExportPreferences.RTFExportGranularity.getGranularity(this.preferences.getInt("rtf_large_mode", RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT.getId())));
        this.rtfExportPreferences[1].setCadratHeight(this.preferences.getInt("rtf_small_size", 12));
        this.rtfExportPreferences[1].setExportGranularity(RTFExportPreferences.RTFExportGranularity.getGranularity(this.preferences.getInt("rtf_small_mode", RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT.getId())));
        this.rtfExportPreferences[2].setCadratHeight(this.preferences.getInt("rtf_file_size", 12));
        this.rtfExportPreferences[2].setExportGranularity(RTFExportPreferences.RTFExportGranularity.getGranularity(this.preferences.getInt("rtf_file_mode", RTFExportPreferences.RTFExportGranularity.GROUPED_CADRATS.getId())));
    }

    public void savePreferences() {
        this.preferences.put("prefversion", "2a10");
        this.preferences.put("currentMDCDirectory", this.currentMDCDirectory.getAbsolutePath());
        this.preferences.put("currentOutputDirectory", this.currentOutputDirectory.getAbsolutePath());
        this.preferences.put("wmfExportFile", this.wmfExporter.getExportFile().getAbsolutePath());
        this.preferences.put("currentHieroglyphsSource", this.currentHieroglyphsSource.getAbsolutePath());
        this.preferences.putInt("rtf_large_size", this.rtfExportPreferences[0].getCadratHeight());
        this.preferences.putInt("rtf_large_mode", this.rtfExportPreferences[0].getExportGranularity().getId());
        this.preferences.putInt("rtf_small_size", this.rtfExportPreferences[1].getCadratHeight());
        this.preferences.putInt("rtf_small_mode", this.rtfExportPreferences[1].getExportGranularity().getId());
        this.preferences.putInt("rtf_file_size", this.rtfExportPreferences[2].getCadratHeight());
        this.preferences.putInt("rtf_file_mode", this.rtfExportPreferences[2].getExportGranularity().getId());
    }

    public void saveText() {
        JFileChooser fc = new JFileChooser(this.currentMDCDirectory);
        fc.setDialogTitle("save to");
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".hie") || pathname.getName().endsWith(".gly") || pathname.getName().endsWith(".GLY") || pathname.isDirectory();
            }

            public String getDescription() {
                return "Manuel de codage files";
            }
        };
        if (this.currentFile != null) {
            fc.setSelectedFile(this.currentFile);
        }
        fc.addChoosableFileFilter(filter);
        int result = fc.showSaveDialog(this.frame);
        if (result == 0) {
            int opt;
            if (!this.currentFile.equals(fc.getSelectedFile()) && fc.getSelectedFile().exists() && (opt = JOptionPane.showConfirmDialog(this.frame, "" + fc.getSelectedFile().getName() + " will be replaced. Are you sure ?", "confirm", 0)) == 1) {
                return;
            }
            String correctExtension = null;
            correctExtension = this.data.isPhilologyIsSign() ? "gly" : "hie";
            this.currentFile = FileUtils.buildFileWithExtension(fc.getSelectedFile(), correctExtension);
            try {
                FileWriter f = new FileWriter(this.currentFile);
                ModelWriter w = new ModelWriter();
                w.write(f, this.data.getModel());
                ((Writer)f).close();
            }
            catch (IOException e) {
                String message = "Could not write to " + this.currentFile.getAbsolutePath();
                if (!this.currentFile.canWrite()) {
                    message = message + " (no write permission)";
                }
                JOptionPane.showMessageDialog(this.frame, message);
            }
        }
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications;
    }

    public void setFrame(MDCDisplayerAppliFrame frame) {
        this.frame = frame;
        this.caretActionManager = new CaretActionManager(this.getEditor().getWorkflow());
        this.caretActionManager.addAction(this.cutAction);
        this.caretActionManager.addAction(this.copyAction);
        this.caretActionManager.addAction(this.wmfExportAction);
        this.caretActionManager.addAction(this.groupHorizontallyAction);
        this.caretActionManager.addAction(this.groupVerticallyAction);
        this.caretActionManager.addAction(this.shadeZoneAction);
        this.caretActionManager.addAction(this.unShadeZoneAction);
        this.caretActionManager.addAction(this.paintRedAction);
        this.caretActionManager.addAction(this.paintBlackAction);
    }

    public void setMessage(String code) {
        this.message.setText(code);
    }

    private void setPhilologySign(boolean philologySign) {
        this.data.setPhilologyIsSign(philologySign);
        for (int i = 5; i < this.getPhilologyActions().length; ++i) {
            this.getPhilologyActions()[i].setEnabled(philologySign);
        }
    }

    public void editPreferences() {
        PreferencesFacade preferencesFacade = new PreferencesFacade(this.preferedUnit, this.rtfExportPreferences);
        PreferencesEditor preferencesEditor = new PreferencesEditor(this.frame, preferencesFacade);
        preferencesEditor.initializePreferences(preferencesFacade);
        int ok = preferencesEditor.askForPreferences();
        if (ok == 0) {
            preferencesEditor.updatePreferences(preferencesFacade);
            this.firePreferencesChange();
        }
    }

    public AbstractAction getSelectCenteredSignsAction() {
        return new AbstractAction("Center single signs"){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)e.getSource();
                    MDCDisplayerAppliWorkflow.this.getDrawingSpecifications().setSmallSignsCentered(checkBox.isSelected());
                    MDCDisplayerAppliWorkflow.this.getEditor().getDrawingSpecifications().setSmallSignsCentered(checkBox.isSelected());
                    MDCDisplayerAppliWorkflow.this.getEditor().invalidateView();
                    System.out.println("redrawing");
                }
            }
        };
    }

    public AbstractAction getLigatureBeforeAction() {
        return this.ligatureBeforeAction;
    }

    public AbstractAction getLigatureAfterAction() {
        return this.ligatureAfterAction;
    }

    public void selectCopyPasteConfiguration(int configurationNumber) {
        this.rtfExportPreferencesIndex = configurationNumber;
    }

    public MDCModelTransferable buildTransferable(TopItemList top) {
        MDCModelTransferable result = new MDCModelTransferable(top);
        result.setDrawingSpecifications(this.getDrawingSpecifications());
        result.setRtfPreferences(this.rtfExportPreferences[this.rtfExportPreferencesIndex]);
        return result;
    }

    class SizeAction
    extends AbstractAction {
        private int size;

        public SizeAction(int size) {
            super("" + size + "%");
            this.size = size;
        }

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().resizeSign(this.size);
        }
    }

    class ShadeAction
    extends MDCIconAction {
        private int shade;

        public ShadeAction(int shade, String mdc) {
            super(mdc);
            this.shade = shade;
        }

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().doShade(this.shade);
        }
    }

    class RotationAction
    extends AbstractAction {
        private int angle;

        public RotationAction(int angle) {
            super("" + angle + "deg.");
            this.angle = angle;
        }

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().changeAngle(this.angle);
        }
    }

    class InsertElementAction
    extends MDCIconAction {
        ModelElement element;

        public InsertElementAction(ModelElement element, String mdcText) {
            super(mdcText);
            this.element = element;
        }

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().insertElement(this.element);
        }
    }

    class CartoucheAction
    extends MDCIconAction {
        private int end;
        private int start;
        private int type;

        public CartoucheAction(int type, int start, int end, String mdcText) {
            super(mdcText);
            this.type = type;
            this.start = start;
            this.end = end;
        }

        public void actionPerformed(ActionEvent e) {
            MDCDisplayerAppliWorkflow.this.getEditor().getWorkflow().addCartouche(this.type, this.start, this.end);
        }
    }
}

