/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.ListOfTopItems;
import jsesh.mdc.model.MDCPosition;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdcDisplayer.clipboard.MDCModelTransferable;
import jsesh.mdcDisplayer.draw.MDCCaret;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.editor.JMDCEditorWorkflow;
import jsesh.mdcDisplayer.swing.editor.MDCEditorEventsListener;
import jsesh.mdcDisplayer.swing.editor.MDCEditorKeyManager;
import jsesh.mdcDisplayer.swing.editor.MDCModelEditionListener;
import jsesh.mdcDisplayer.swing.editor.MDCModelTransferableBroker;
import jsesh.mdcDisplayer.swing.editor.MDCViewUpdater;
import jsesh.mdcDisplayer.swing.editor.SimpleMDCModelTransferableBroker;
import jsesh.swingUtils.GraphicsUtils;

public class JMDCEditor
extends JPanel {
    private JMDCModelEditionListener mdcModelEditionListener;
    SimpleViewBuilder builder;
    private boolean debug = false;
    protected ViewDrawer drawer;
    MDCView mdcView;
    private double scale;
    private MDCViewUpdater viewUpdater;
    MDCEditorEventsListener eventListener;
    JMDCEditorWorkflow workflow;
    MDCModelTransferableBroker mdcModelTransferableBroker = new SimpleMDCModelTransferableBroker();
    private boolean caretChanged = true;
    private DrawingSpecifications drawingSpecifications = MDCEditorKit.getBasicMDCEditorKit().getDrawingSpecifications();

    public JMDCEditor() {
        this(new HieroglyphicTextModel());
    }

    public JMDCEditor(HieroglyphicTextModel data) {
        this.setBackground(Color.WHITE);
        this.drawer = new ViewDrawer();
        this.drawer.setCached(true);
        this.setScale(2.0);
        this.builder = new SimpleViewBuilder();
        this.mdcView = null;
        this.workflow = new JMDCEditorWorkflow(data);
        this.mdcModelEditionListener = new JMDCModelEditionListener();
        this.workflow.addMDCModelListener(this.mdcModelEditionListener);
        this.setFocusable(true);
        this.viewUpdater = new MDCViewUpdater(this);
        this.eventListener = new MDCEditorEventsListener(this);
        MDCEditorKeyManager.getInstance().control(this);
    }

    public void addCodeChangeListener(MDCModelEditionListener l) {
        this.workflow.addMDCModelListener(l);
    }

    public void deleteCodeChangeListener(MDCModelEditionListener l) {
        this.workflow.deleteCodeChangeListener(l);
    }

    public String getCodeBuffer() {
        return this.workflow.getCurrentCode().toString();
    }

    public HieroglyphicTextModel getHieroglyphicTextModel() {
        return this.workflow.getHieroglyphicTextModel();
    }

    protected MDCCaret getMDCCaret() {
        return this.workflow.getCaret();
    }

    public Dimension getPreferredSize() {
        if (this.getHieroglyphicTextModel() == null) {
            return new Dimension(600, 600);
        }
        MDCView v = this.getView();
        if (v.getWidth() == 0.0f || v.getHeight() == 0.0f) {
            v.setWidth(14.0f);
            v.setHeight(14.0f);
        }
        return new Dimension((int)(this.scale * (double)v.getWidth()), (int)(this.scale * (double)v.getHeight()));
    }

    public double getScale() {
        return this.scale;
    }

    public MDCView getView() {
        if (this.mdcView == null) {
            this.mdcView = this.builder.buildView(this.getHieroglyphicTextModel().getModel(), this.getDrawingSpecifications());
            this.revalidate();
            if (this.debug) {
                System.out.println(this.mdcView);
            }
        }
        return this.mdcView;
    }

    public JMDCEditorWorkflow getWorkflow() {
        return this.workflow;
    }

    protected void moveCursorToMouse(Point p) {
        Point clickPoint = (Point)p.clone();
        clickPoint.x = (int)((double)clickPoint.x / this.getScale());
        clickPoint.y = (int)((double)clickPoint.y / this.getScale());
        MDCPosition pos = this.drawer.getPositionForPoint(this.getView(), clickPoint, this.getDrawingSpecifications());
        if (pos != null) {
            this.workflow.setCursor(pos);
        }
    }

    protected void moveMarkToMouse(Point p) {
        Point clickPoint = (Point)p.clone();
        clickPoint.x = (int)((double)clickPoint.x / this.getScale());
        clickPoint.y = (int)((double)clickPoint.y / this.getScale());
        MDCPosition pos = this.drawer.getPositionForPoint(this.getView(), clickPoint, this.getDrawingSpecifications());
        this.workflow.setMark(pos);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtils.antialias(g2d);
        g2d.scale(this.scale, this.scale);
        this.drawer.setClip(true);
        this.drawer.DrawViewAndCursor(g2d, this.getView(), this.getMDCCaret(), this.getDrawingSpecifications());
        if (this.caretChanged) {
            this.caretChanged = false;
            Rectangle r = this.getPointerRectangle();
            if (!g.getClipBounds().contains(r)) {
                r.height += 4;
                r.width += 4;
                r.x -= 2;
                r.y -= 2;
                SwingUtilities.invokeLater(new VisibilityScroller(r));
            }
        }
    }

    public void print(Graphics g) {
        this.drawer.setClip(false);
        this.drawer.draw((Graphics2D)g, this.getView(), this.getDrawingSpecifications());
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setScale(double d) {
        this.scale = d;
        if (this.drawer.isCached()) {
            this.drawer.flushCache();
        }
        this.repaint();
        this.revalidate();
    }

    public int getInsertPositiont() {
        return this.workflow.getCaret().getInsert().getIndex();
    }

    Rectangle getPointerRectangle() {
        Rectangle2D r1 = this.drawer.getRectangleAroundPosition(this.getView(), this.workflow.getCaret().getInsert().getPosition(), this.getDrawingSpecifications());
        int w = (int)(r1.getWidth() * this.getScale());
        int h = (int)(r1.getHeight() * this.getScale());
        if (w < 2) {
            w = 2;
        }
        if (h < 2) {
            h = 2;
        }
        Rectangle r = new Rectangle((int)(r1.getX() * this.getScale()), (int)(r1.getY() * this.getScale()), w, h);
        return r;
    }

    public void setTextOrientation(TextOrientation orientation) {
        this.getDrawingSpecifications().setTextOrientation(orientation);
        this.invalidateView();
    }

    public void setTextDirection(TextDirection direction) {
        this.getDrawingSpecifications().setTextDirection(direction);
        this.invalidateView();
    }

    public TextOrientation getTextOrientation() {
        return this.getDrawingSpecifications().getTextOrientation();
    }

    public TextDirection getTextDirection() {
        return this.getDrawingSpecifications().getTextDirection();
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications;
        this.invalidateView();
    }

    public void invalidateView() {
        this.mdcView = null;
        if (this.drawer.isCached()) {
            this.drawer.flushCache();
        }
        this.repaint();
    }

    public char getCurrentSeparator() {
        return this.getWorkflow().getCurrentSeparator();
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            System.out.println("getting content");
            Transferable t = clipboard.getContents(this);
            if (t != null) {
                System.out.println("asking for list of top items");
                if (t.isDataFlavorSupported(MDCModelTransferable.ListOfTopItemsFlavor)) {
                    ListOfTopItems l = (ListOfTopItems)t.getTransferData(MDCModelTransferable.ListOfTopItemsFlavor);
                    System.err.println("data got");
                    this.workflow.insertElements(l);
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                    this.workflow.insertElement(new AlphabeticText('l', string));
                }
            }
        }
        catch (IllegalStateException exception) {
            exception.printStackTrace();
        }
        catch (UnsupportedFlavorException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void copy() {
        TopItemList top = this.getWorkflow().getSelectionAsTopItemList();
        MDCModelTransferable transferable = this.mdcModelTransferableBroker.buildTransferable(top);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    public void cut() {
        this.copy();
        this.getWorkflow().cut();
    }

    public void setMdcModelTransferableBroker(MDCModelTransferableBroker mdcModelTransferableBroker) {
        this.mdcModelTransferableBroker = mdcModelTransferableBroker;
    }

    private class JMDCModelEditionListener
    implements MDCModelEditionListener {
        private JMDCModelEditionListener() {
        }

        public void textEdited(ModelOperation op) {
            op.accept(JMDCEditor.this.viewUpdater);
            JMDCEditor.this.caretChanged = true;
            JMDCEditor.this.revalidate();
            JMDCEditor.this.repaint();
        }

        public void textChanged() {
            JMDCEditor.this.mdcView = null;
        }

        public void caretChanged(MDCCaret caret) {
            JMDCEditor.this.caretChanged = true;
            JMDCEditor.this.repaint();
        }

        public void codeChanged(StringBuffer code) {
        }

        public void separatorChanged() {
        }

        public void focusGained(StringBuffer code) {
        }

        public void focusLost() {
        }
    }

    private class VisibilityScroller
    implements Runnable {
        Rectangle r;

        public VisibilityScroller(Rectangle r) {
            this.r = r;
        }

        public void run() {
            JMDCEditor.this.scrollRectToVisible(this.r);
            JMDCEditor.this.repaint();
        }
    }
}

