/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jsesh.hieroglyphs.HieroglyphsManager;
import jsesh.hieroglyphs.PossibilitiesList;
import jsesh.mdc.constants.WordEndingCode;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.MDCMark;
import jsesh.mdc.model.MDCPosition;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdc.model.utilities.BasicItemListGrouper;
import jsesh.mdc.model.utilities.CadratStarInserter;
import jsesh.mdc.model.utilities.ComplexLigatureExtractor;
import jsesh.mdc.model.utilities.GroupExploder;
import jsesh.mdc.model.utilities.HieroglyphExtractor;
import jsesh.mdc.model.utilities.HorizontalGrouper;
import jsesh.mdc.model.utilities.InnerGroupBuilder;
import jsesh.mdc.model.utilities.LastHieroglyphSelector;
import jsesh.mdc.model.utilities.VerticalGrouper;
import jsesh.mdc.output.ModelWriter;
import jsesh.mdc.utils.MDCSyntaxError;
import jsesh.mdcDisplayer.draw.DrawUtilities;
import jsesh.mdcDisplayer.draw.MDCCaret;
import jsesh.mdcDisplayer.draw.MDCCaretChangeListener;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.editor.MDCModelEditionListener;

public class JMDCEditorWorkflow
implements Observer,
MDCCaretChangeListener {
    private static List copyBuffer;
    private MDCCaret caret;
    private StringBuffer currentCode;
    private char currentSeparator = (char)32;
    private HieroglyphicTextModel hieroglyphicTextModel;
    private List listeners;
    private char mode;
    private PossibilitiesList possibilities;

    public JMDCEditorWorkflow(HieroglyphicTextModel data) {
        this.hieroglyphicTextModel = data;
        this.hieroglyphicTextModel.addObserver(this);
        this.caret = new MDCCaret(data.getModel());
        this.caret.addCaretChangeListener(this);
        this.currentCode = new StringBuffer("");
        this.listeners = new ArrayList();
        this.mode = (char)115;
    }

    private void addAlphabeticChar(char key) {
        this.possibilities = null;
        if (key == '\b') {
            if (this.caret.getInsert().hasPrevious()) {
                TopItem t = this.caret.getInsert().getElementBefore();
                if (t instanceof AlphabeticText) {
                    AlphabeticText txt = (AlphabeticText)t;
                    if (txt.getText().length() == 0) {
                        this.doBackspace();
                    } else {
                        txt.setText(txt.getText().substring(0, txt.getText().length() - 1));
                        if (txt.getText().length() == 0) {
                            this.doBackspace();
                        }
                    }
                } else {
                    this.doBackspace();
                }
            }
        } else {
            boolean addNew = false;
            if (!this.caret.getInsert().hasPrevious()) {
                addNew = true;
            } else {
                TopItem t = this.caret.getInsert().getElementBefore();
                if (t instanceof AlphabeticText && ((AlphabeticText)t).getScriptCode() == this.mode) {
                    AlphabeticText txt = (AlphabeticText)t;
                    txt.setText(txt.getText() + key);
                } else {
                    addNew = true;
                }
            }
            if (addNew) {
                this.insertElement(new AlphabeticText(this.mode, "" + key));
            }
        }
        this.clearSeparator();
    }

    public boolean addCartouche(int type, int start, int end) {
        boolean result;
        BasicItemListGrouper grouper = new BasicItemListGrouper();
        List elts = this.suppressSelection();
        BasicItemList l = grouper.extractBasicItemList(elts);
        if (l != null) {
            Cartouche c = new Cartouche(type, start, end, l);
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c);
            result = true;
        } else {
            this.pasteList(elts);
            result = false;
        }
        this.clearSeparator();
        return result;
    }

    public void addLowerLevel() {
        TopItemList l = this.hieroglyphicTextModel.getModel();
        EmbeddedModelElement elt = l.getChildAt(this.getInsertPosition() - 1);
        if (elt instanceof Cadrat) {
            Cadrat c = (Cadrat)elt;
            HBox hbox = new HBox();
            Hieroglyph hiero = this.buildHieroglyphFromCode(this.currentCode.toString());
            hbox.addHorizontalListElement(hiero);
            c.addHBox(hbox);
            this.clearCode();
            this.clearSeparator();
        }
    }

    public void addMDCModelListener(MDCModelEditionListener l) {
        this.listeners.add(l);
    }

    public boolean addPhilologicalMarkup(int type) {
        boolean result;
        this.possibilities = null;
        if (this.getHieroglyphicTextModel().isPhilologyIsSign()) {
            int max = this.caret.getMax();
            int min = this.caret.getMin();
            this.hieroglyphicTextModel.getModel().addTopItemAt(max, new Hieroglyph(type * 2 + 1).buildTopItem());
            this.hieroglyphicTextModel.getModel().addTopItemAt(min, new Hieroglyph(type * 2).buildTopItem());
            result = true;
        } else {
            BasicItemListGrouper grouper = new BasicItemListGrouper();
            List elts = this.suppressSelection();
            BasicItemList l = grouper.extractBasicItemList(elts);
            if (l != null) {
                Philology c = new Philology(type, l);
                this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c.buildTopItem());
                result = true;
            } else {
                this.pasteList(elts);
                result = false;
            }
        }
        this.clearSeparator();
        return result;
    }

    public void addSameLevel() {
        TopItemList l = this.hieroglyphicTextModel.getModel();
        EmbeddedModelElement elt = l.getChildAt(this.getInsertPosition() - 1);
        if (elt instanceof Cadrat) {
            Cadrat c = (Cadrat)elt;
            HBox hbox = c.getHBox(c.getNumberOfChildren() - 1);
            Hieroglyph hiero = this.buildHieroglyphFromCode(this.currentCode.toString());
            hbox.addHorizontalListElement(hiero);
            this.clearCode();
            this.clearSeparator();
        }
    }

    public void addSeparator(char sep) {
        if (this.currentCode.length() != 0) {
            this.addSign();
        }
        this.groupBy(this.currentSeparator);
        this.currentSeparator = sep;
        this.notifyCodeChangeListeners();
        this.notifySeparatorChangeListeners();
    }

    public void addSign() {
        if (this.getCurrentCode().length() == 0) {
            return;
        }
        this.possibilities = HieroglyphsManager.getInstance().getPossibilityFor(this.currentCode.toString());
        if (this.possibilities == null) {
            this.addSign(this.currentCode.toString());
        } else {
            this.addSign(this.possibilities.getCurrentSign());
        }
    }

    public void addSign(String code) {
        TopItemList t = this.hieroglyphicTextModel.getModel();
        Cadrat cadrat = new Cadrat();
        HBox hbox = new HBox();
        cadrat.addHBox(hbox);
        hbox.addHorizontalListElement(this.buildHieroglyphFromCode(code));
        t.addTopItemAt(this.getInsertPosition(), cadrat);
        this.clearCode();
    }

    public void addToCode(char c) {
        this.possibilities = null;
        this.currentCode.append(c);
        this.notifyCodeChangeListeners();
    }

    public AbsoluteGroup buildAbsoluteGroup() {
        AbsoluteGroup result = null;
        if (!this.caret.hasMark() && this.getInsertPosition() >= 1) {
            this.caret.setMarkAt(this.getInsertPosition() - 1);
        }
        if (this.caret.hasMark()) {
            List elts = this.suppressSelection();
            AbsoluteGroup g = DrawUtilities.createAbsoluteGroupFrom(elts, MDCEditorKit.getBasicMDCEditorKit().getDrawingSpecifications());
            if (g.getNumberOfChildren() != 0) {
                this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), g.buildTopItem());
                result = (AbsoluteGroup)g.deepCopy();
            } else {
                this.pasteList(elts);
            }
        }
        return result;
    }

    private Hieroglyph buildHieroglyphFromCode(String code) {
        Hieroglyph hiero = "o".equals(code) ? new Hieroglyph(3) : new Hieroglyph(code);
        return hiero;
    }

    public void caretChanged(MDCCaret caret) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MDCModelEditionListener l = (MDCModelEditionListener)i.next();
            l.caretChanged(caret);
        }
    }

    public void changeAngle(int angle) {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setAngle(angle);
        }
    }

    public void clear() {
        try {
            this.possibilities = null;
            this.setMDCCode("");
            this.clearSeparator();
        }
        catch (MDCSyntaxError e) {
            throw new RuntimeException(e);
        }
        this.currentCode.setLength(0);
        this.clearSeparator();
    }

    public void clearCode() {
        this.currentCode.setLength(0);
        this.notifyCodeChangeListeners();
    }

    public void clearMark() {
        this.possibilities = null;
        this.caret.unsetMark();
        this.clearSeparator();
    }

    public void clearSeparator() {
        this.currentSeparator = (char)32;
        this.notifySeparatorChangeListeners();
    }

    public void cursorDown() {
        this.possibilities = null;
        MDCPosition p = this.caret.getInsert().getPosition();
        p = p.getNextPosition(1);
        while (p.hasNext() && !p.getElementBefore().isBreak()) {
            p = p.getNextPosition(1);
        }
        this.caret.setInsertPosition(p);
        this.caret.unsetMark();
        this.clearSeparator();
    }

    public void cursorNext() {
        this.possibilities = null;
        this.caret.moveInsertBy(1);
        this.caret.unsetMark();
        this.clearSeparator();
    }

    public void cursorPrevious() {
        this.possibilities = null;
        this.caret.moveInsertBy(-1);
        this.caret.unsetMark();
        this.clearSeparator();
    }

    public void cursorToBeginningOfLine() {
        this.possibilities = null;
        MDCPosition p = this.getLineFirstPosition();
        this.caret.setInsertPosition(p);
        this.clearSeparator();
    }

    public void cursorToEndOfLine() {
        this.possibilities = null;
        MDCPosition p = this.getLineLastPosition();
        this.caret.setInsertPosition(p);
    }

    public void cursorUp() {
        this.possibilities = null;
        MDCPosition p = this.caret.getInsert().getPosition();
        p = p.getNextPosition(-1);
        while (p.hasPrevious() && !p.getElementAfter().isBreak()) {
            p = p.getNextPosition(-1);
        }
        this.caret.setInsertPosition(p);
        this.cursorToBeginningOfLine();
        this.caret.unsetMark();
        this.clearSeparator();
    }

    public void cut() {
        List l = this.suppressSelection();
        this.clearSeparator();
    }

    public void deleteCodeChangeListener(MDCModelEditionListener l) {
        this.listeners.remove(l);
    }

    public void deleteCursorChangeListener(MDCCaretChangeListener l) {
        this.caret.removeCaretChangeListener(l);
    }

    public void doBackspace() {
        this.possibilities = null;
        if (this.currentCode.length() > 0) {
            this.currentCode.replace(this.currentCode.length() - 1, this.currentCode.length(), "");
            this.notifyCodeChangeListeners();
        } else if (this.currentSeparator != ' ') {
            this.clearSeparator();
        } else {
            this.removeTopItem();
        }
        this.clearSeparator();
    }

    public void doShade(int shade) {
        TopItem t;
        this.possibilities = null;
        if (this.caret.getInsert().hasPrevious() && (t = this.caret.getInsert().getElementBefore()) instanceof Cadrat) {
            Cadrat c = (Cadrat)t;
            c.setShading(shade);
        }
    }

    public void expandSelection(int dir) {
        if (!this.caret.hasMark()) {
            this.caret.setMark(new MDCMark(this.caret.getInsert().getPosition()));
        }
        this.caret.advanceInsertBy(dir);
    }

    public void explodeGroup() {
        if (this.caret.getInsert().getIndex() < 1) {
            return;
        }
        GroupExploder f = new GroupExploder();
        List elts = this.getHieroglyphicTextModel().getModel().removeTopItems(this.caret.getInsert().getIndex() - 1, this.caret.getInsert().getIndex());
        if (elts.size() == 1) {
            List result = f.explode((TopItem)elts.get(0));
            this.pasteList(result);
        } else {
            this.pasteList(elts);
        }
        this.clearSeparator();
    }

    public void fixAbsoluteGroup(AbsoluteGroup g) {
        this.clearSeparator();
        TopItem t = this.getCurrentItem();
        if (t != null && t instanceof Cadrat) {
            this.removeTopItem();
            g.compact();
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.getInsertPosition(), g.buildTopItem());
        }
    }

    public void focusGained() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MDCModelEditionListener listener = (MDCModelEditionListener)this.listeners.get(i);
            listener.focusGained(this.currentCode);
        }
    }

    public void focusLost() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MDCModelEditionListener listener = (MDCModelEditionListener)this.listeners.get(i);
            listener.focusLost();
        }
    }

    public MDCCaret getCaret() {
        return this.caret;
    }

    public StringBuffer getCurrentCode() {
        return this.currentCode;
    }

    public TopItem getCurrentItem() {
        TopItem t = null;
        if (this.caret.getInsert().hasPrevious()) {
            t = this.caret.getInsert().getElementBefore();
        }
        return t;
    }

    public String getCurrentLineAsString() {
        TopItemList t = this.getHieroglyphicTextModel().getModel();
        int[] limits = this.getLineLimits();
        StringWriter sw = new StringWriter();
        ModelWriter w = new ModelWriter();
        w.write(sw, t, limits[0], limits[1]);
        return sw.toString();
    }

    public char getCurrentSeparator() {
        return this.currentSeparator;
    }

    public HieroglyphicTextModel getHieroglyphicTextModel() {
        return this.hieroglyphicTextModel;
    }

    private int getInsertPosition() {
        return this.caret.getInsert().getPosition().getIndex();
    }

    public Hieroglyph getLastHieroglyph() {
        Hieroglyph result = null;
        TopItem t = this.getCurrentItem();
        if (t != null) {
            LastHieroglyphSelector selector = new LastHieroglyphSelector();
            result = selector.findLastHieroglyph(t);
        }
        return result;
    }

    private MDCPosition getLineFirstPosition() {
        MDCPosition first = this.caret.getInsert().getPosition();
        while (first.hasPrevious() && !first.getElementBefore().isBreak()) {
            first = first.getNextPosition(-1);
        }
        return first;
    }

    private MDCPosition getLineLastPosition() {
        MDCPosition second = this.caret.getInsert().getPosition();
        while (second.hasNext() && !second.getElementAfter().isBreak()) {
            second = second.getNextPosition(1);
        }
        return second;
    }

    private int[] getLineLimits() {
        int[] result = new int[2];
        MDCPosition first = this.getLineFirstPosition();
        MDCPosition second = this.getLineLastPosition();
        if (second.hasNext()) {
            second = second.getNextPosition(1);
        }
        result[0] = first.getIndex();
        result[1] = second.getIndex();
        return result;
    }

    public String getMDCCode() {
        StringWriter sw = new StringWriter();
        ModelWriter w = new ModelWriter();
        w.write(sw, this.getHieroglyphicTextModel().getModel());
        return sw.toString();
    }

    public char getMode() {
        return this.mode;
    }

    private void groupBy(char key) {
        switch (key) {
            case ' ': 
            case '-': {
                break;
            }
            case '*': {
                if (this.caret.getInsert().getIndex() <= 1) break;
                this.insertLastCadratIntoBeforeLast();
                break;
            }
            case ':': {
                if (this.caret.getInsert().getIndex() <= 1) break;
                this.groupLastTwoVertically();
                break;
            }
            case '&': {
                if (this.caret.getInsert().getIndex() <= 1) break;
                this.ligatureLastTwoElements();
                break;
            }
            default: {
                throw new RuntimeException("bad separator " + key);
            }
        }
    }

    public boolean groupHorizontal() {
        boolean result;
        HorizontalGrouper f = new HorizontalGrouper();
        List elts = this.suppressSelection();
        Cadrat c = f.buildCadrat(elts);
        if (c != null) {
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c);
            result = true;
        } else {
            this.pasteList(elts);
            result = false;
        }
        this.clearSeparator();
        return result;
    }

    private void groupLastTwoVertically() {
        VerticalGrouper f = new VerticalGrouper();
        List elts = this.getHieroglyphicTextModel().getModel().removeTopItems(this.caret.getInsert().getIndex() - 2, this.caret.getInsert().getIndex());
        Cadrat c = f.buildCadrat(elts);
        if (c != null) {
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c);
        } else {
            this.pasteList(elts);
        }
        this.clearSeparator();
    }

    public boolean groupVertical() {
        boolean result;
        VerticalGrouper v = new VerticalGrouper();
        List elts = this.suppressSelection();
        Cadrat c = v.buildCadrat(elts);
        if (c != null) {
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c);
            result = true;
        } else {
            this.pasteList(elts);
            result = false;
        }
        this.clearSeparator();
        return result;
    }

    public void insertElement(ModelElement e) {
        this.possibilities = null;
        this.getHieroglyphicTextModel().getModel().addTopItemAt(this.caret.getInsert().getIndex(), e.buildTopItem());
    }

    public void insertElements(List elements) {
        this.possibilities = null;
        this.getHieroglyphicTextModel().getModel().addAllAt(this.getInsertPosition(), elements);
    }

    public void insertHalfSpace() {
        this.possibilities = null;
        Hieroglyph h = new Hieroglyph(1);
        this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), h.buildTopItem());
    }

    private void insertLastCadratIntoBeforeLast() {
        CadratStarInserter f = new CadratStarInserter();
        List elts = this.getHieroglyphicTextModel().getModel().removeTopItems(this.caret.getInsert().getIndex() - 2, this.caret.getInsert().getIndex());
        Cadrat c = f.buildCadrat((TopItem)elts.get(0), (TopItem)elts.get(1));
        if (c != null) {
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), c);
        } else {
            this.pasteList(elts);
        }
    }

    public void insertMDC(String mdcText) {
        try {
            this.possibilities = null;
            this.getHieroglyphicTextModel().insertMDCText(this.caret.getInsert().getIndex(), mdcText);
        }
        catch (MDCSyntaxError e) {
            throw new RuntimeException(e);
        }
    }

    public void insertNewLine() {
        this.possibilities = null;
        this.addSeparator(' ');
        this.getHieroglyphicTextModel().getModel().addTopItemAt(this.getInsertPosition(), new LineBreak());
    }

    public void insertPageBreak() {
        this.possibilities = null;
        this.addSeparator(' ');
        this.getHieroglyphicTextModel().getModel().addTopItemAt(this.getInsertPosition(), new PageBreak());
    }

    public void insertSpace() {
        this.possibilities = null;
        Hieroglyph h = new Hieroglyph(2);
        this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), h.buildTopItem());
    }

    public boolean isCodeChar(char key) {
        return Character.isLetterOrDigit(key) || key == '\'';
    }

    public boolean isSeparatorChar(char key) {
        return key == ' ' || key == '-' || key == ':' || key == '*' || key == '&';
    }

    public void keyTyped(char key) {
        if (this.mode == 's') {
            if (this.currentSeparator == ' ' && key == ' ' && this.currentCode.length() == 0) {
                this.nextPossibility();
            } else if (key == '\b') {
                this.doBackspace();
            } else if (key == ',') {
                this.currentCode.replace(0, this.currentCode.length(), "Ff1");
            } else if (this.isSeparatorChar(key)) {
                if (key == '-') {
                    key = (char)32;
                }
                this.addSeparator(key);
            } else if (this.isCodeChar(key)) {
                this.addToCode(key);
            }
        } else {
            this.addAlphabeticChar(key);
        }
    }

    public boolean ligatureElements() {
        boolean result = false;
        HieroglyphExtractor extractor = new HieroglyphExtractor();
        List elts = this.suppressSelection();
        List hieros = extractor.extractHieroglyphs(elts);
        if (hieros != null && hieros.size() > 1) {
            Ligature lig = new Ligature();
            Iterator it = hieros.iterator();
            while (it.hasNext()) {
                Hieroglyph h = (Hieroglyph)it.next();
                lig.addHieroglyph((Hieroglyph)h.deepCopy());
            }
            this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), lig.buildTopItem());
            result = true;
        } else {
            this.pasteList(elts);
            result = false;
        }
        this.clearSeparator();
        return result;
    }

    private void ligatureLastTwoElements() {
        this.caret.setMarkAt(this.caret.getInsert().getIndex() - 2);
        if (this.caret.getMax() - this.caret.getMin() == 2) {
            this.ligatureElements();
        }
        this.clearSeparator();
    }

    public void nextPossibility() {
        Hieroglyph h;
        if (this.possibilities != null && (h = this.getLastHieroglyph()) != null) {
            this.possibilities.next();
            h.setCode(this.possibilities.getCurrentSign());
        }
    }

    private void notifyCodeChangeListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MDCModelEditionListener listener = (MDCModelEditionListener)this.listeners.get(i);
            listener.codeChanged(this.currentCode);
        }
    }

    private void notifySeparatorChangeListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MDCModelEditionListener listener = (MDCModelEditionListener)this.listeners.get(i);
            listener.separatorChanged();
        }
    }

    private void pasteList(List elts) {
        ArrayList<ModelElement> l = new ArrayList<ModelElement>(elts.size());
        Iterator i = elts.iterator();
        while (i.hasNext()) {
            l.add(((TopItem)i.next()).deepCopy());
        }
        this.hieroglyphicTextModel.getModel().addAllAt(this.caret.getInsert().getIndex(), l);
        this.clearSeparator();
    }

    public void redZone(boolean b) {
        this.possibilities = null;
        if (this.caret.hasMark()) {
            this.hieroglyphicTextModel.getModel().setRed(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex(), b);
        }
        this.clearSeparator();
    }

    public void removeTopItem() {
        this.possibilities = null;
        TopItemList l = this.hieroglyphicTextModel.getModel();
        l.removeTopItem(this.getInsertPosition() - 1);
        this.clearSeparator();
    }

    public void resizeSign(int size) {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setRelativeSize(size);
        }
    }

    public void reverseSign() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setReversed(!h.isReversed());
        }
    }

    public void selectAll() {
        this.possibilities = null;
        this.caret.moveInsertTo(0);
        this.caret.setMarkAt(this.hieroglyphicTextModel.getModel().getNumberOfChildren());
        this.clearSeparator();
    }

    public boolean setCurrentLineTo(String text) {
        this.possibilities = null;
        boolean success = true;
        TopItemList t = this.getHieroglyphicTextModel().getModel();
        int[] limits = this.getLineLimits();
        try {
            List items = this.getHieroglyphicTextModel().buildItems(text);
            this.getHieroglyphicTextModel().getModel().removeTopItems(limits[0], limits[1]);
            this.getHieroglyphicTextModel().getModel().addAllAt(limits[0], items);
            this.caret.setInsertPosition(new MDCPosition(t, limits[0]));
        }
        catch (MDCSyntaxError e) {
            success = false;
        }
        this.clearSeparator();
        return success;
    }

    public void setCursor(MDCPosition position) {
        if (position != null) {
            this.possibilities = null;
            this.caret.setInsert(new MDCMark(position));
            this.clearSeparator();
        }
    }

    public void setMark(MDCPosition position) {
        if (position != null) {
            this.possibilities = null;
            this.caret.setMark(new MDCMark(position));
            this.clearSeparator();
        }
    }

    public void setMarkToCursor() {
        this.possibilities = null;
        this.caret.setMarkAt(this.caret.getInsert().getIndex());
        this.clearSeparator();
    }

    public void setMDCCode(String txt) throws MDCSyntaxError {
        this.possibilities = null;
        this.getHieroglyphicTextModel().setMDCCode(txt);
        this.clearSeparator();
    }

    public void setMode(char mode) {
        this.possibilities = null;
        this.mode = mode;
        this.clearSeparator();
    }

    public void setSignIsAtSentenceEnd() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setEndingCode(WordEndingCode.SENTENCE_END);
        }
    }

    public void setSignIsAtWordEnd() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setEndingCode(WordEndingCode.WORD_END);
        }
    }

    public void setSignIsInsideWord() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setEndingCode(WordEndingCode.NONE);
        }
    }

    public void shadeZone(boolean shade) {
        this.possibilities = null;
        if (this.caret.hasMark()) {
            this.hieroglyphicTextModel.getModel().shade(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex(), shade);
        }
        this.clearSeparator();
    }

    private List suppressSelection() {
        this.possibilities = null;
        List result = null;
        if (this.caret.hasMark()) {
            int a = Math.min(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex());
            int b = Math.max(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex());
            result = this.hieroglyphicTextModel.getModel().removeTopItems(a, b);
            this.clearMark();
        }
        this.clearSeparator();
        return result;
    }

    public void toggleGrammar() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.setGrammar(!h.isGrammar());
        }
    }

    public void toggleIgnoredSign() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.getModifiers().setBoolean("i", !h.getModifiers().getBoolean("i"));
        }
    }

    public void toggleRedSign() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.getModifiers().setBoolean("red", !h.getModifiers().getBoolean("red"));
        }
    }

    public void toggleWideSign() {
        Hieroglyph h = this.getLastHieroglyph();
        if (h != null) {
            h.getModifiers().setBoolean("l", !h.getModifiers().getBoolean("l"));
        }
    }

    public void update(Observable o, Object arg) {
        if (arg == null) {
            this.caret.changeModel(this.hieroglyphicTextModel.getModel());
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                MDCModelEditionListener l = (MDCModelEditionListener)i.next();
                l.textChanged();
            }
            this.clearSeparator();
        } else if (arg instanceof ModelOperation) {
            ModelOperation op = (ModelOperation)arg;
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                MDCModelEditionListener l = (MDCModelEditionListener)i.next();
                l.textEdited(op);
            }
        } else {
            throw new RuntimeException("should not happen.");
        }
    }

    public void doComplexLigature(int signPos) {
        boolean success = false;
        List elts = this.suppressSelection();
        if (elts == null) {
            return;
        }
        if (elts.size() > 1 && signPos < elts.size()) {
            HieroglyphExtractor extractor;
            List hieros;
            InnerGroup group1 = null;
            InnerGroup group2 = null;
            Hieroglyph h = null;
            if (signPos == -1) {
                signPos = elts.size() - 1;
            }
            ComplexLigatureExtractor ligatureExtractor = new ComplexLigatureExtractor();
            ligatureExtractor.extract((ModelElement)elts.get(signPos));
            if (!ligatureExtractor.foundOtherElements() && ligatureExtractor.getComplexLigature() != null) {
                ComplexLigature c1 = ligatureExtractor.getComplexLigature();
                if (c1.getBeforeGroup() != null) {
                    group1 = (InnerGroup)c1.getBeforeGroup().deepCopy();
                }
                if (c1.getAfterGroup() != null) {
                    group2 = (InnerGroup)c1.getAfterGroup().deepCopy();
                }
                h = (Hieroglyph)c1.getHieroglyph().deepCopy();
            }
            if (h == null && (hieros = (extractor = new HieroglyphExtractor()).extractHieroglyphs(elts.subList(signPos, signPos + 1))).size() == 1) {
                h = (Hieroglyph)hieros.get(0);
            }
            boolean error = false;
            if (h != null) {
                InnerGroupBuilder innerGroupBuilder;
                if (signPos > 0) {
                    if (group1 == null) {
                        innerGroupBuilder = new InnerGroupBuilder();
                        innerGroupBuilder.buildHorizontalElement(elts.subList(0, signPos));
                        group1 = innerGroupBuilder.getGroup();
                    } else {
                        error = true;
                    }
                }
                if (signPos < elts.size() - 1) {
                    if (group2 == null) {
                        innerGroupBuilder = new InnerGroupBuilder();
                        innerGroupBuilder.buildHorizontalElement(elts.subList(signPos + 1, elts.size()));
                        group2 = innerGroupBuilder.getGroup();
                    } else {
                        error = true;
                    }
                }
                if (!(error || group1 == null && group2 == null)) {
                    ComplexLigature ligature = new ComplexLigature(group1, h, group2);
                    this.hieroglyphicTextModel.getModel().addTopItemAt(this.caret.getInsert().getIndex(), ligature.buildTopItem());
                    success = true;
                }
            }
        }
        if (!success) {
            this.pasteList(elts);
        }
        this.clearSeparator();
    }

    public void ligatureBefore() {
        this.doComplexLigature(-1);
    }

    public void ligatureAfter() {
        this.doComplexLigature(0);
    }

    public TopItemList getSelectionAsTopItemList() {
        TopItemList topItemList = new TopItemList();
        if (this.caret.hasMark()) {
            int a = Math.min(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex());
            int b = Math.max(this.caret.getInsert().getIndex(), this.caret.getMark().getIndex());
            for (int i = a; i < b; ++i) {
                topItemList.addTopItem((TopItem)this.hieroglyphicTextModel.getModel().getChildAt(i).deepCopy());
            }
        }
        return topItemList;
    }
}

