/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import jsesh.mdcDisplayer.swing.editor.JMDCEditorWorkflow;

final class MDCEditorEventsListener
extends MouseInputAdapter
implements FocusListener {
    private final JMDCEditor editor;
    private boolean dragging;

    MDCEditorEventsListener(JMDCEditor editor) {
        this.editor = editor;
        this.dragging = false;
        editor.addMouseListener(this);
        editor.addMouseMotionListener(this);
        editor.addFocusListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            this.editor.getWorkflow().setMarkToCursor();
        }
        Point p = e.getPoint();
        this.editor.moveCursorToMouse(p);
        this.editor.requestFocusInWindow();
        this.dragging = true;
    }

    public void mousePressed(MouseEvent e) {
        int action = 0;
        if (this.dragging) {
            this.dragging = false;
            return;
        }
        if (e.getButton() == 1) {
            action = 1;
            if (e.isShiftDown()) {
                action = 2;
            }
        } else if (e.getButton() == 3) {
            action = 2;
        }
        if (action == 1) {
            Point p = e.getPoint();
            this.editor.moveCursorToMouse(p);
            this.getWorkflow().clearMark();
            this.editor.requestFocusInWindow();
        } else if (action == 2) {
            Point p = e.getPoint();
            this.editor.moveMarkToMouse(p);
            this.editor.requestFocusInWindow();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.getWorkflow().focusGained();
    }

    public void focusLost(FocusEvent e) {
        this.getWorkflow().focusLost();
    }

    private JMDCEditorWorkflow getWorkflow() {
        return this.editor.workflow;
    }
}

